/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.writer.log4j;

import org.apache.log4j.*;

/**
 * Log4JRollingFileAppendergMessageWriterT[rXB<p>
 * 
 * @author M.Takata
 */
public class RollingFileMessageWriterService extends FileMessageWriterService
 implements RollingFileMessageWriterServiceMBean {
    
    private static final long serialVersionUID = 360683732716933676L;
    
    /**[e[ṼgK[ƂȂt@CTCY*/
    private long maxFileSize = -1;
    /**őǗ*/
    private int maxBackups = -1;
    
    /**
     * CX^X𐶐B<p>
     */
    public RollingFileMessageWriterService(){
        super();
    }
    
    // RollingFileMessageWriterServiceMBeanJavaDoc
    public void setMaximumFileSize(long maxFileSize){
        this.maxFileSize = maxFileSize;
    }
    
    // RollingFileMessageWriterServiceMBeanJavaDoc
    public long getMaximumFileSize(){
        return maxFileSize;
    }
    
    // RollingFileMessageWriterServiceMBeanJavaDoc
    public void setMaxBackupIndex(int maxBackups){
        this.maxBackups = maxBackups;
    }
    
    // RollingFileMessageWriterServiceMBeanJavaDoc
    public int getMaxBackupIndex(){
        return maxBackups;
    }
    
    /**
     * RollingFileAppenderCX^X𐶐āACX^Xϐ{@link #appender}B<p>
     *
     * @exception Exception RollingFileAppender̐Ɏsꍇ
     */
    protected WriterAppender createWriterAppender() throws Exception{
        return new RollingFileAppender();
    }
    
    /**
     * RollingFileAppenderB<p>
     *
     * @exception Exception RollingFileAppendeȑɎsꍇ
     */
    protected void initWriterAppender(WriterAppender appender) throws Exception{
        super.initWriterAppender(appender);
        final RollingFileAppender rolling = (RollingFileAppender)appender;
        if(maxFileSize > 0){
            rolling.setMaximumFileSize(maxFileSize);
        }
        if(maxBackups > 0){
            rolling.setMaxBackupIndex(maxBackups);
        }
    }
}
