/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.sql;

import java.util.Properties;

import jp.ossc.nimbus.core.*;

/**
 * {@link JDBCConnectionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see JDBCConnectionFactoryService
 */
public interface JDBCConnectionFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * JDBChCõNXݒ肷B<p>
     *
     * @param name JDBChCõNX
     */
    public void setDriverName(String name);
    
    /**
     * JDBChCõNX擾B<p>
     *
     * @return JDBChCõNX
     */
    public String getDriverName();
    
    /**
     * JDBCڑURLݒ肷B<p>
     *
     * @param url JDBCڑURL
     */
    public void setConnectionURL(String url);
    
    /**
     * JDBCڑURL擾B<p>
     *
     * @return JDBCڑURL
     */
    public String getConnectionURL();
    
    /**
     * JDBCڑ[Uݒ肷B<p>
     *
     * @param name JDBCڑ[U
     */
    public void setUserName(String name);
    
    /**
     * JDBCڑ[U擾B<p>
     *
     * @return JDBCڑ[U
     */
    public String getUserName();
    
    /**
     * JDBCڑpX[hݒ肷B<p>
     *
     * @param password JDBCڑpX[h
     */
    public void setPassword(String password);
    
    /**
     * JDBCڑpX[h擾B<p>
     *
     * @return JDBCڑpX[h
     */
    public String getPassword();
    
    /**
     * JDBCڑvpeBݒ肷B<p>
     * {@link #setUserName(String)}A{@link #setPassword(String)}ƕp鎖͂łȂB<br>
     *
     * @param prop JDBCڑvpeB
     */
    public void setConnectionProperties(Properties prop);
    
    /**
     * JDBCڑvpeB擾B<p>
     *
     * @return JDBCڑvpeB
     */
    public Properties getConnectionProperties();
    
    /**
     * R~bgݒ肷B<p>
     * ftHǵAtrueB
     *
     * @param isAuto R~bgɂꍇ́Atrue
     */
    public void setAutoCommit(boolean isAuto);
    
    /**
     * R~bg肷B<p>
     *
     * @return R~bg̏ꍇ́Atrue
     */
    public boolean isAutoCommit();
}
