/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import jp.ossc.nimbus.core.*;

/**
 * {@link DatabaseConditionScheduleMakerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface DatabaseConditionScheduleMakerServiceMBean
 extends DefaultScheduleMakerServiceMBean{
    
    /**
     * {jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ConnectionFactoryT[rX̃T[rX
     */
    public void setConnectionFactoryServiceName(ServiceName name);
    
    /**
     * {jp.ossc.nimbus.service.sql.ConnectionFactory ConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getConnectionFactoryServiceName();
    
    /**
     * XPW[̍쐬L𔻒fSQLݒ肷B<p>
     * KAXPW[쐬t𖄂ߍ݃p[^ƂĎAʂBoolean^Al^A^̂ꂩɂȂSQLƂ鎖B<br>
     * Boolean^̏ꍇ́AtruȅꍇAXPW[쐬B<br>
     * l^̏ꍇ́A0ȊO̒l̏ꍇAXPW[쐬B<br>
     * ^̏ꍇ́A"0"ȊO̒l̏ꍇAXPW[쐬B<br>
     * <pre>
     *  FcƓł΃XPW[쐬ꍇ
     *   select count(1) from businessday_calendar where date = ?
     * </pre>
     *
     * @param query SQL
     */
    public void setQuery(String query);
    
    /**
     * XPW[̍쐬L𔻒fSQL擾B<p>
     *
     * @return SQL
     */
    public String getQuery();
    
    /**
     * ttH[}bgݒ肷B<p>
     * {@link #setQuery(String)}Ŏw肵SQLɖߍރXPW[쐬t𕶎ƂēnꍇɁA̓ttH[}bgw肷B<br>
     * 
     * @param format ttH[}bg
     */
    public void setDateFormat(String format);
    
    /**
     * ttH[}bg擾B<p>
     * 
     * @return ttH[}bg
     */
    public String getDateFormat();
}