/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import jp.ossc.nimbus.core.*;

/**
 * {@link AbstractScheduleExecutorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface AbstractScheduleExecutorServiceMBean extends ServiceBaseMBean{
    
    /**
     * XPW[sJnꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_RUN = "ASE__00001";
    
    /**
     * XPW[sIꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_END = "ASE__00002";
    
    /**
     * XPW[̎sɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_EXECUTE_ERROR = "ASE__00003";
    
    /**
     * XPW[̍ăXPW[sꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_RESCHEDULE = "ASE__00004";
    
    /**
     * XPW[̍ăXPW[Ɏsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_RESCHEDULE_ERROR = "ASE__00005";
    
    /**
     * XPW[̃gCIɓBꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_RETRY_END_ERROR = "ASE__00006";
    
    /**
     * XPW[Iꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_ABORT = "ASE__00007";
    
    /**
     * XPW[̏ԕύXɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_STATE_CHANGE_ERROR = "ASE__00008";
    
    /**
     * XPW[̏ԑJڂɎsꍇ̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_STATE_TRANS_ERROR = "ASE__00009";
    
    /**
     * {@link ScheduleManager}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ScheduleManagerT[rX̃T[rX
     */
    public void setScheduleManagerServiceName(ServiceName name);
    
    /**
     * {@link ScheduleManager}T[rX̃T[rX擾B<p>
     *
     * @return ScheduleManagerT[rX̃T[rX
     */
    public ServiceName getScheduleManagerServiceName();
    
    /**
     * ScheduleExecutor肷L[ݒ肷B<p>
     * ftHǵAT[rXB<br>
     *
     * @param key L[
     */
    public void setKey(String key);
    
    /**
     * ScheduleExecutor肷L[擾B<p>
     *
     * @return L[
     */
    public String getKey();
    
    /**
     * ScheduleExecutorsXPW[s̎ނݒ肷B<p>
     *
     * @param type XPW[s̎
     */
    public void setType(String type);
    
    /**
     * ScheduleExecutorsXPW[s̎ނ擾B<p>
     *
     * @return XPW[s̎
     */
    public String getType();
}
