/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.resource.jms;

import javax.jms.Session;
import javax.jms.JMSException;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.resource.Resource;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.ResourceException;
import jp.ossc.nimbus.service.jms.JMSSessionFactory;
import jp.ossc.nimbus.service.jms.JMSSessionCreateException;

public class SessionResourceFactoryService extends ServiceBase
 implements ResourceFactory<Session>, SessionResourceFactoryServiceMBean{
    
    private static final long serialVersionUID = 1288827712194315589L;
    
    private ServiceName jmsSessionFactoryServiceName;
    private JMSSessionFactory jmsSessionFactory;
    private boolean isManaged = false;
    
    private boolean isSetAckMode;
    private int ackMode = Session.AUTO_ACKNOWLEDGE;
    private boolean isSetTransactionMode;
    private boolean transactionMode;
    
    @Override
    public void setJMSSessionFactoryServiceName(ServiceName name){
        jmsSessionFactoryServiceName = name;
    }
    @Override
    public ServiceName getJMSSessionFactoryServiceName(){
        return jmsSessionFactoryServiceName;
    }
    
    @Override
    public void setAcknowledgeMode(int mode){
        isSetAckMode = true;
        ackMode = mode;
    }
    @Override
    public int getAcknowledgeMode(){
        return ackMode;
    }
    
    @Override
    public void setTransactionMode(boolean isTransacted){
        isSetTransactionMode = true;
        transactionMode = isTransacted;
    }
    @Override
    public boolean getTransactionMode(){
        return transactionMode;
    }
    
    @Override
    public void setManaged(boolean isManaged){
        this.isManaged = isManaged;
    }
    @Override
    public boolean isManaged(){
        return isManaged;
    }
    
    public void setJMSSessionFactory(JMSSessionFactory fac) {
        jmsSessionFactory = fac;
    }
    
    @Override
    public void startService() throws Exception{
        if(jmsSessionFactoryServiceName != null){
            jmsSessionFactory = ServiceManagerFactory
                .getServiceObject(jmsSessionFactoryServiceName);
        }
        if(jmsSessionFactory == null){
            throw new IllegalArgumentException("JMSSessionFactory is null.");
        }
    }
    
    @Override
    public Resource<Session> makeResource(Object key) throws ResourceException{
        try{
            Session session = !isSetAckMode && !isSetTransactionMode
                    ? jmsSessionFactory.getSession()
                        : jmsSessionFactory.getSession(transactionMode, ackMode);
            return new SessionResource(
                jmsSessionFactory.getConnection(),
                session,
                isManaged,
                session.getTransacted()
            );
        }catch(JMSSessionCreateException e){
            throw new ResourceException(e);
        }catch(JMSException e){
            throw new ResourceException(e);
        }
    }
}