/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link MessageForwardingService}MBeanC^tF[XB<p>
 *
 * @author M.Ishida
 * @see MessageForwardingService
 */
public interface MessageForwardingServiceMBean extends MessageReceiverServiceMBean {
    
    public static final String MSG_ID_SEND_ERROR            = "PMFS_00001";
    public static final String MSG_ID_FORWARD_ERROR         = "PMFS_00002";
    
    /**
     * ]悩vꂽ]ɑMłȂꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public String getSendErrorMessageId();
    
    /**
     * ]悩vꂽ]ɑMłȂꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @param id ObZ[WID
     */
    public void setSendErrorMessageId(String id);
    
    /**
     * ]̔zM]ɑMłȂꍇɏo͂郍ObZ[WIDݒ肷B<p>
     *
     * @param id ObZ[WID
     */
    public String getForwardErrorMessageId();
    
    /**
     * ]̔zM]ɑMłȂꍇɏo͂郍ObZ[WID擾B<p>
     *
     * @return ObZ[WID
     */
    public void setForwardErrorMessageId(String id);
    
    /**
     * ]{@link ServerConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ServerConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getServerConnectionFactoryServiceName();
    
    /**
     * ]{@link ServerConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ServerConnectionFactoryT[rX̃T[rX
     */
    public void setServerConnectionFactoryServiceName(ServiceName serverConnectionFactoryServiceName);
    
    /**
     * ]ɔ񓯊M邩ǂݒ肷B<p>
     * truȅꍇA]{@link ServerConnection}{@link ServerConnection#sendAsynch(Message)}őMB<br>
     * falsȅꍇA]ServerConnection{@link ServerConnection#send(Message)}őMB<br>
     * ftHǵAfalseœMB<br>
     * 
     * @param isAsynch 񓯊Mꍇtrue
     */
    public void setAsynchSend(boolean isAsynch);
    
    /**
     * ]ɔ񓯊M邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇA񓯊M
     */
    public boolean isAsynchSend();
}
