/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.proxy;

import jp.ossc.nimbus.core.*;

/**
 * {@link ProxyClientService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ProxyClientService
 */
public interface ProxyClientServiceMBean<T> extends FactoryServiceBaseMBean<T>{
    
    /**
     * vLVT[rX̃C^tF[Xݒ肷B<p>
     *
     * @param className vLVT[rX̃C^tF[X
     */
    public void setProxyInterfaceClassName(String className);
    
    /**
     * vLVT[rX̃C^tF[X擾B<p>
     *
     * @return vLVT[rX̃C^tF[X
     */
    public String getProxyInterfaceClassName();
    
    /**
     * vLVT[rX̃T[rXݒ肷B<p>
     * Ŏw肳ꂽT[rX́A{@link jp.ossc.nimbus.service.aop.InvocationContext#setTargetObject(Object) InvocationContext.setTargetObject(Object)}ŁAĂяoΏۂ̃T[rXƂē`dB<br>
     *
     * @param name vLVT[rX̃T[rX
     */
    public void setProxyServiceName(ServiceName name);
    
    /**
     * vLVT[rX̃T[rX擾B<p>
     *
     * @return vLVT[rX̃T[rX
     */
    public ServiceName getProxyServiceName();
    
    /**
     * vLVɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rXݒ肷B<p>
     * C^[Zv^ݍ܂Ȃꍇ́Aݒ肵ȂĂǂB<br>
     *
     * @param name InterceptorChainListT[rX̃T[rX
     */
    public void setInterceptorChainListServiceName(ServiceName name);
    
    /**
     * vLVɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChainList InterceptorChainList}T[rX̃T[rX擾B<p>
     *
     * @return InterceptorChainListT[rX̃T[rX
     */
    public ServiceName getInterceptorChainListServiceName();
    
    /**
     * vLVT[rXĂяo{@link jp.ossc.nimbus.service.aop.Invoker Invoker}T[rX̃T[rXݒ肷B<p>
     *
     * @param name InvokerT[rX̃T[rX
     */
    public void setInvokerServiceName(ServiceName name);
    
    /**
     * vLVT[rXĂяo{@link jp.ossc.nimbus.service.aop.Invoker Invoker}T[rX̃T[rX擾B<p>
     *
     * @return InvokerT[rX̃T[rX
     */
    public ServiceName getInvokerServiceName();
    
    /**
     * vLVɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChain InterceptorChain}𐶐{@link jp.ossc.nimbus.service.aop.InterceptorChainFactory InterceptorChainFactory}̃T[rXݒ肷B<p>
     *
     * @param name InterceptorChainFactoryT[rX̃T[rX
     */
    public void setInterceptorChainFactoryServiceName(ServiceName name);
    
    /**
     * vLVɋݍ{@link jp.ossc.nimbus.service.aop.InterceptorChain InterceptorChain}𐶐{@link jp.ossc.nimbus.service.aop.InterceptorChainFactory InterceptorChainFactory}̃T[rX擾B<p>
     *
     * @return InterceptorChainFactoryT[rX̃T[rX
     */
    public ServiceName getInterceptorChainFactoryServiceName();
    
    /**
     * vLV𖈉񐶐邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     * 
     * @param isCreate 񐶐ꍇtrue
     */
    public void setCreateNewProxy(boolean isCreate);
    
    /**
     * vLV𖈉񐶐邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇA񐶐
     */
    public boolean isCreateNewProxy();
    
    /**
     * vLVɕRtăC^[Zv^`FC𐶐邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     * 
     * @param isCreate Rtꍇtrue
     */
    public void setCreateInterceptorChainByProxy(boolean isCreate);
    
    /**
     * vLVɕRtăC^[Zv^`FC𐶐邩ǂ𔻒肷B<p>
     * 
     * @return truȅꍇARt
     */
    public boolean isCreateInterceptorChainByProxy();
}
