/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.log;

import java.util.Locale;

/**
 * OC^[tFCXB<p>
 * 
 * @author Y.Tokuda
 */
public interface Logger{
    
    /**
     * w肵bZ[WID̃bZ[WOɏo͂B<p>
     *
     * @param messageId bZ[WID
     * @param embed ߍ݃p[^
     */
    public void write(String messageId, Object... embed);
    
    /**
     * w肵bZ[WID̗OtbZ[WOɏo͂B<p>
     *
     * @param messageId bZ[WID
     * @param oException O
     * @param embed ߍ݃p[^
     */
    public void write(String messageId, Throwable oException, Object... embed);
    
    /**
     * w肵bZ[WID̎w胍P[ߍ݃bZ[WOɏo͂B<p>
     * w肵P[̃bZ[WȂꍇɂ́A߂P[̃bZ[Wo͂B<br>
     *
     * @param messageId bZ[WID
     * @param lo P[
     * @param embed ߍ݃p[^
     */
    public void write(String messageId, Locale lo, Object... embed);
    
    /**
     * w肵bZ[WID̗Otw胍P[ߍ݃bZ[WOɏo͂B<p>
     *
     * @param messageId bZ[WID
     * @param lo P[
     * @param oException O
     * @param embed ߍ݃p[^
     */
    public void write(String messageId, Locale lo, Throwable oException, Object... embed);
    
    /**
     * w肳ꂽbZ[WID̃bZ[WOo͂邩ǂ𔻒肷B<p>
     *
     * @param messageId bZ[WID
     * @return w肳ꂽbZ[WID̃bZ[WOo͂ꍇtrue
     */
    public boolean isWrite(String messageId);
}
