/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.EditorFinder;
import jp.ossc.nimbus.service.journal.JournalEditor;

/**
 * W[iMapIuWFNgɃtH[}bgGfB^T[rX̊NXB<p>
 * 
 * @author M.Takata
 */
public abstract class MapJournalEditorServiceBase extends ServiceBase
 implements JournalEditor, MapJournalEditorServiceBaseMBean{
    
    private static final long serialVersionUID = 7133997016215000363L;
    
    protected static final String DEFAULT_SECRET_STRING = "******";
    
    protected String[] secretMapKeys;
    protected Set<String> secretMapKeySet;
    protected String secretString = DEFAULT_SECRET_STRING;
    protected String[] enabledMapKeys;
    protected Set<String> enabledMapKeySet;
    protected String[] disabledMapKeys;
    protected Set<String> disabledMapKeySet;
    
    @Override
    public void setSecretMapKeys(String[] names){
        secretMapKeys = names;
    }
    
    @Override
    public String[] getSecretMapKeys(){
        return secretMapKeys;
    }
    
    @Override
    public void setSecretString(String str){
        secretString = str;
    }
    
    @Override
    public String getSecretString(){
        return secretString;
    }
    
    @Override
    public void setEnabledMapKeys(String[] names){
        enabledMapKeys = names;
    }
    
    @Override
    public String[] getEnabledMapKeys(){
        return enabledMapKeys;
    }
    
    @Override
    public void setDisabledMapKeys(String[] names){
        disabledMapKeys = names;
    }
    
    @Override
    public String[] getDisabledMapKeys(){
        return disabledMapKeys;
    }
    
    @Override
    protected void preStartService() throws Exception{
        super.preStartService();
        if(secretMapKeys != null && secretMapKeys.length != 0){
            secretMapKeySet = new HashSet<String>(secretMapKeys.length);
            for(String prop : secretMapKeys){
                secretMapKeySet.add(prop);
            }
        }
        if(enabledMapKeys != null && enabledMapKeys.length != 0){
            enabledMapKeySet = new HashSet<String>(enabledMapKeys.length);
            for(String prop : enabledMapKeys){
                enabledMapKeySet.add(prop);
            }
        }
        if(disabledMapKeys != null && disabledMapKeys.length != 0){
            disabledMapKeySet = new HashSet<String>(disabledMapKeys.length);
            for(String prop : disabledMapKeys){
                disabledMapKeySet.add(prop);
            }
        }
    }
    
    protected boolean isOutputMapKey(String key){
        if(key != null
            && disabledMapKeySet != null
            && disabledMapKeySet.contains(key)
        ){
            return false;
        }
        if(key != null
            && enabledMapKeySet != null
            && !enabledMapKeySet.contains(key)
        ){
            return false;
        }
        return true;
    }
    
    protected boolean isSecretMapKey(String key){
        return key != null && secretMapKeySet != null && secretMapKeySet.contains(key);
    }
    
    protected boolean putMap(Map<String, Object> map, String key, Object value){
        if(isOutputMapKey(key)){
            if(isSecretMapKey(key)){
                map.put(key, getSecretString());
            }else{
                map.put(key, value);
            }
            return true;
        }else{
            return false;
        }
    }
    
    // JournalEditorJavaDoc
    @Override
    public Object toObject(EditorFinder finder, String key, Object value){
        return toMap(finder, key, value);
    }
    
    /**
     * W[iƂė^ꂽ^̏W[iƂďo͂MapɕϊB<br>
     * 
     * @param finder K؂JournalEditor񋟂EditorFinder
     * @param key W[ĩL[
     * @param value W[i
     * @return W[iƂďo͂Map
     */
    protected abstract Map<String, Object> toMap(EditorFinder finder, String key, Object value);
    
    /**
     * GfB^[sȃIuWFNgK؂ȃGfB^ŕҏWB<p>
     * finderŁAvaluě^ɑΉGfB^擾ĕҏWBGfB^Ȃꍇ́A{@link Object#toString()}ŕɕϊĕԂB<br>
     *
     * @param finder EditorFinderT[rX
     * @param key L[
     * @param obj W[iIuWFNg
     * @return W[i
     */
    protected Object makeObjectFormat(
        EditorFinder finder,
        String key,
        Object obj
    ){
        Object value = null;
        if(obj != null){
            final JournalEditor editor = finder.findEditor(key, obj);
            if(editor != null){
                value = editor.toObject(finder, key, obj);
            }else{
                value = obj.toString();
            }
        }
        return value;
    }
}
