/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import javax.jms.*;

/**
 * JMS bZ[Wvf[Tt@NgB<p>
 * 
 * @author M.Takata
 */
public interface JMSMessageProducerFactory{
    
    /**
     * ̃t@NgێĂSession擾B<p>
     * createProducer\bhŁAMessageProducer𐶐ۂɁASessionw肵Ȃꍇ́ASessiongpB<br>
     *
     * @return ̃t@NgێĂSessionBSessionێĂȂꍇnullB
     */
    public Session getSession();
    
    /**
     * ̃t@NgSession̎擾Ɏgp{@link JMSSessionFactory}T[rX擾B<p>
     *
     * @return {@link JMSSessionFactory}T[rX
     */
    public JMSSessionFactory getSessionFactory();
    
    /**
     * ̃t@NgێĂDestination擾B<p>
     * createProducer\bhŁAMessageProducer𐶐ۂɁADestinationw肵Ȃꍇ́ADestinationgpB<br>
     *
     * @return ̃t@NgێĂDestinationBDestinationێĂȂꍇnullB
     */
    public Destination getDestination();
    
    /**
     * MessageProducer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createProducer(Destination)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageProducerCreateExceptionthrowB<br>
     * ܂ADestinatiońA{@link #getDestination()}Ŏ擾DestinationgpBgetDestination()nullԂꍇ́AJMSMessageProducerCreateExceptionthrowB<br>
     *
     * @return MessageProducer
     * @exception JMSMessageProducerCreateException MessageProducer̐Ɏsꍇ
     */
    public MessageProducer createProducer()
     throws JMSMessageProducerCreateException;
    
    /**
     * MessageProducer𐶐B<p>
     * {@link #getSession()}Ŏ擾SessionA{@link Session#createProducer(Destination)}\bhŐB<br>
     * getSession()nullԂꍇ́AJMSMessageProducerCreateExceptionthrowB<br>
     *
     * @param dest ƂȂDestination
     * @return MessageProducer
     * @exception JMSMessageProducerCreateException MessageProducer̐Ɏsꍇ
     */
    public MessageProducer createProducer(Destination dest)
     throws JMSMessageProducerCreateException;
    
    /**
     * MessageProducer𐶐B<p>
     * w肳ꂽSessionA{@link Session#createProducer(Destination)}\bhŐB<br>
     *
     * @param session Session
     * @param dest ƂȂDestination
     * @return MessageProducer
     * @exception JMSMessageProducerCreateException MessageProducer̐Ɏsꍇ
     */
    public MessageProducer createProducer(Session session, Destination dest)
     throws JMSMessageProducerCreateException;
}