/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jms;

import jp.ossc.nimbus.core.*;

/**
 * {@link JMSConnectionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see JMSConnectionFactoryService
 */
public interface JMSConnectionFactoryServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * Đڑ[hFĐڑȂB<p>
     */
    public static int AUTO_RECONNECT_MODE_NON = 0;
    
    /**
     * Đڑ[hFJNDIT[o񕜌mɍĐڑB<p>
     */
    public static int AUTO_RECONNECT_MODE_ON_RECOVER = ReconnectableConnection.RECONNECT_MODE_ON_RECOVER;
    
    /**
     * Đڑ[hFJNDIT[o_EmɍĐڑB<p>
     */
    public static int AUTO_RECONNECT_MODE_ON_DEAD = ReconnectableConnection.RECONNECT_MODE_ON_DEAD;
    
    /**
     * ConnectionFactoryNamẽftHglB<p>
     * ftHgł́AJ2EEReĩ[JXAڑgpB
     */
    public static final String DEFAULT_CONNECTION_FACTORY_NAME
         = "java:XAConnectionFactory";
    
    /**
     * ConnectionKeỹftHglB<p>
     */
    public static final String DEFAULT_CONNECTION_KEY
         = "JMSConnection";
    
    /**
     * JMSRlNṼCX^XP邩ǂݒ肷B<p>
     * JMSRlNV́AIȐڑ\IuWFNgł邽߁AʏCX^X́APĎgpׂłB<br>
     * ftHǵAtrueB<br>
     *
     * @param isSingle JMSRlNṼCX^XPꍇtrue
     */
    public void setSingleConnection(boolean isSingle);
    
    /**
     * JMSRlNṼCX^XP邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAJMSRlNṼCX^XP
     */
    public boolean isSingleConnection();
    
    /**
     * JMSRlNVǗ邩ǂݒ肷B<p>
     * trueݒ肵ꍇAJMSRlNV́ÃT[rXɂĕێĂAT[rX̒~ƋJMSRlNV̏IsB
     * \[X̊JRh߂̋@\łB<br>
     * AASingleConnectiontrueɐݒ肵Ăꍇ́ȂtrueɂȂĂl̏sB<br>
     * ftHǵAfalseB<br>
     *
     * @param isManaged JMSRlNVǗꍇtrue
     */
    public void setConnectionManagement(boolean isManaged);
    
    /**
     * JMSRlNVǗ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAJMSRlNVǗ
     */
    public boolean isConnectionManagement();
    
    /**
     * Connection𐶐鎞Connection̊Jn邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isStart Connection̊Jnꍇtrue
     */
    public void setStartConnection(boolean isStart);
    
    /**
     * Connection̊Jn邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAConnection̊Jn
     */
    public boolean isStartConnection();
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     * Őݒ肳ꂽJndiFinderT[rXgāAJNDIT[ojavax.jms.ConnectionFactorylookupB<br>
     *
     * @param name JndiFinderT[rX̃T[rX
     */
    public void setJndiFinderServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rX擾B<p>
     *
     * @return JndiFinderT[rX̃T[rX
     */
    public ServiceName getJndiFinderServiceName();
    
    /**
     * javax.jms.ConnectionFactoryJNDIݒ肷B<p>
     * ftHǵA{@link #DEFAULT_CONNECTION_FACTORY_NAME}B<br>
     *
     * @param name javax.jms.ConnectionFactoryJNDI
     * @see #DEFAULT_CONNECTION_FACTORY_NAME
     */
    public void setConnectionFactoryName(String name);
    
    /**
     * javax.jms.ConnectionFactoryJNDI擾B<p>
     *
     * @return javax.jms.ConnectionFactoryJNDI
     */
    public String getConnectionFactoryName();
    
    /**
     * JMSڑ[Uݒ肷B<p>
     * J2EEReiJMSڑɑ΂ăZLeBݒsĂꍇɁAݒ肷B<br>
     *
     * @param name JMSڑ[U
     */
    public void setUserName(String name);
    
    /**
     * JMSڑ[U擾B<p>
     *
     * @return JMSڑ[U
     */
    public String getUserName();
    
    /**
     * JMSڑpX[hݒ肷B<p>
     * J2EEReiJMSڑɑ΂ăZLeBݒsĂꍇɁAݒ肷B<br>
     *
     * @param passwd JMSڑpX[h
     */
    public void setPassword(String passwd);
    
    /**
     * JMSڑpX[h擾B<p>
     *
     * @return JMSڑpX[h
     */
    public String getPassword();
    
    /**
     * {@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rXݒ肷B<p>
     * SingleConnectiontrueɐݒ肵Ăꍇ̂ݗLŁAJMSRlNVAŐݒ肳ꂽCacheMapT[rXɃLbVB
     * ̍ۂ̃LbVL[́AConnectionKey̒lgpB<br>
     * LbVJMSRlNVLbVAEgƁAmJMSRlNV̏IsB<br>
     * ʏA{@link jp.ossc.nimbus.service.jndi.CachedJndiFinderService CachedJndiFinderService}CacheMapServiceNameŐݒ肵CacheMapT[rXpACachedJndiFinderServiceJNDIT[o_EmۂɁALbVNA@\𗘗pāAJMSRlNV̍ĐڑsB<br>
     *
     * @param name CacheMapT[rX̃T[rX
     */
    public void setConnectionCacheMapServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rX̃T[rX擾B<p>
     *
     * @return CacheMapT[rX̃T[rX
     */
    public ServiceName getConnectionCacheMapServiceName();
    
    /**
     * JMSRlNVLbVۂ̃LbVL[ݒ肷B<p>
     * SingleConnectiontrueɂāAConnectionCacheMapServiceNameݒ肵ĂꍇɁAJMSRlNV{@link jp.ossc.nimbus.service.cache.CacheMap CacheMap}T[rXɃLbVۂ̃L[ݒ肷B<br>
     * ftHǵA{@link #DEFAULT_CONNECTION_KEY}łB<br>
     *
     * @param key JMSRlNVLbVۂ̃LbVL[
     * @see #DEFAULT_CONNECTION_KEY
     */
    public void setConnectionKey(String key);
    
    /**
     * JMSRlNVLbVۂ̃LbVL[擾B<p>
     *
     * @return JMSRlNVLbVۂ̃LbVL[
     */
    public String getConnectionKey();
    
    /**
     * Đڑ[hݒ肷B<p>
     * ftHǵA{@link #AUTO_RECONNECT_MODE_NON}ŁAĐڑȂB<br>
     * Đڑs[hɐݒ肵ꍇ́AJNDIT[o̐māAĐڑsB<br>
     * ܂̏ꍇ́A{@link #setJndiKeepAliveCheckerServiceName(ServiceName)}ŁAJNDIT[o̐m{@link jp.ossc.nimbus.service.distribute.KeepAliveChecker KeepAliveChecker}T[rXݒ肵Ȃ΂ȂȂB<br>
     *
     * @param mode Đڑ[h
     * @see #AUTO_RECONNECT_MODE_NON
     * @see #AUTO_RECONNECT_MODE_ON_RECOVER
     * @see #AUTO_RECONNECT_MODE_ON_DEAD
     * @see #setJndiKeepAliveCheckerServiceName(ServiceName)
     */
    public void setAutoReconnectMode(int mode);
    
    /**
     * Đڑ[hݒ肷B<p>
     *
     * @return Đڑ[h
     */
    public int getAutoReconnectMode();
    
    /**
     * JNDIT[o̐m{@link jp.ossc.nimbus.service.distribute.KeepAliveChecker KeepAliveChecker}T[rX̃T[rXݒ肷B<p>
     *
     * @param name KeepAliveCheckerT[rX̃T[rX
     */
    public void setJndiKeepAliveCheckerServiceName(ServiceName name);
    
    /**
     * JNDIT[o̐m{@link jp.ossc.nimbus.service.distribute.KeepAliveChecker KeepAliveChecker}T[rX̃T[rX擾B<p>
     *
     * @return KeepAliveCheckerT[rX̃T[rX
     */
    public ServiceName getJndiKeepAliveCheckerServiceName();
    
    /**
     * ĐڑɁAڑɎsꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     * ftHǵAnullŁAOo͍͂sȂB<br>
     * 
     * @param id ÕbZ[WID
     */
    public void setAutoReconnectErrorLogMessageId(String id);
    
    /**
     * ĐڑɁAڑɎsꍇɏo͂郍ÕbZ[WID擾B<p>
     * 
     * @return ÕbZ[WID
     */
    public String getAutoReconnectErrorLogMessageId();
    
    /**
     * ĐڑɁAڑɎsꍇɃgCs񐔂ݒ肷B<p>
     * ftHǵA0ŃgCȂB<br>
     *
     * @param count gC
     */
    public void setAutoReconnectMaxRetryCount(int count);
    
    /**
     * ĐڑɁAڑɎsꍇɃgCs񐔂擾B<p>
     *
     * @return gC
     */
    public int getAutoReconnectMaxRetryCount();
    
    /**
     * ĐڑɁAڑɎsꍇɃgCsԊu[ms]ݒ肷B<p>
     * ftHǵA1000[ms]B<br>
     *
     * @param interval gCԊu
     */
    public void setAutoReconnectRetryInterval(long interval);
    
    /**
     * ĐڑɁAڑɎsꍇɃgCsԊu[ms]擾B<p>
     *
     * @return gCԊu
     */
    public long getAutoReconnectRetryInterval();
}
