/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.interpreter;

import java.io.*;

/**
 * R[h̕]ɗOOB<p>
 * 
 * @author M.Takata
 */
public class EvaluateException extends RuntimeException implements Externalizable{
    
    private static final long serialVersionUID = 2527297536258573314L;
    
    private String message;
    
    /**
     * RXgN^B<p>
     */
    public EvaluateException(){
        super();
    }
    
    /**
     * G[bZ[WCX^X𐶐RXgN^B<p>
     *
     * @param message G[bZ[W
     */
    public EvaluateException(String message){
        super();
        this.message = message;
    }
    
    /**
     * ̗ǑƂȂOCX^X𐶐RXgN^B<p>
     *
     * @param cause ƂȂO
     */
    public EvaluateException(Throwable cause){
        super(cause);
    }
    
    /**
     * G[bZ[WƁA̗ǑƂȂOCX^X𐶐RXgN^B<p>
     *
     * @param message G[bZ[W
     * @param cause ƂȂO
     */
    public EvaluateException(String message, Throwable cause){
        super(cause);
        this.message = message;
    }
    
    public String getMessage(){
        return message;
    }
    
    public void writeExternal(ObjectOutput out) throws IOException{
        if(getCause() == null){
            out.writeObject(null);
            out.writeUTF(message);
        }else{
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try{
                oos.writeObject(getCause());
                oos.flush();
                
                out.write(baos.toByteArray());
                out.writeUTF(message);
            }catch(NotSerializableException e){
                out.writeObject(null);
                out.writeUTF(message == null ? getCause().toString() : message + " : " + getCause().toString());
            }finally{
                oos.close();
            }
        }
        out.writeObject(getStackTrace());
    }
    
    public void readExternal(ObjectInput in)
     throws IOException, ClassNotFoundException{
        initCause((Throwable)in.readObject());
        message = in.readUTF();
        setStackTrace((StackTraceElement[])in.readObject());
    }
}