/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DatabaseOHLCDatasetFactoryService}MBeanC^tF[XB<p>
 *
 * @author M.Takata
 */
public interface DatabaseOHLCDatasetFactoryServiceMBean
 extends OHLCDatasetFactoryServiceMBean{
    
    /** ftHgtFb`TCY */
    public static final int DEFAULT_FETCH_SIZE = 10000;
    
    /**
     * t̃Jݒ肷B<p>
     *
     * @param columnName t̃J
     */
    public void setDateColumnName(String columnName);
    
    /**
     * t̃J擾B<p>
     *
     * @return t̃J
     */
    public String getDateColumnName();
    
    /**
     * ̃Jݒ肷B<p>
     * 
     * @param columnName ̃J
     */
    public void setTimeColumnName(String columnName);
    
    /**
     * ̃J擾B<p>
     * 
     * @return ̃J
     */
    public String getTimeColumnName();
    
    /**
     * t̃tH[}bgp^[ݒ肷B<p>
     *
     * @param pattern t̃tH[}bgp^[
     */
    public void setDateFormatPattern(String pattern);
    
    /**
     * t̃tH[}bgp^[擾B<p>
     *
     * @return t̃tH[}bgp^[
     */
    public String getDateFormatPattern();
    
    /**
     * nl̃Jݒ肷B<p>
     *
     * @param columnName nl̃J
     */
    public void setOpenPriceColumnName(String columnName);
    
    /**
     * nl̃J擾B<p>
     *
     * @return nl̃J
     */
    public String getOpenPriceColumnName();
    
    /**
     * l̃Jݒ肷B<p>
     *
     * @param columnName l̃J
     */
    public void setHighPriceColumnName(String columnName);
    
    /**
     * l̃J擾B<p>
     *
     * @return l̃J
     */
    public String getHighPriceColumnName();
    
    /**
     * l̃Jݒ肷B<p>
     *
     * @param columnName l̃J
     */
    public void setLowPriceColumnName(String columnName);
    
    /**
     * l̃J擾B<p>
     *
     * @return l̃J
     */
    public String getLowPriceColumnName();
    
    /**
     * Il̃Jݒ肷B<p>
     *
     * @param columnName Il̃J
     */
    public void setClosePriceColumnName(String columnName);
    
    /**
     * Il̃J擾B<p>
     *
     * @return Il̃J
     */
    public String getClosePriceColumnName();
    
    /**
     * õJݒ肷B<p>
     *
     * @param columnName õJ
     */
    public void setVolumeColumnName(String columnName);
    
    /**
     * õJ擾B<p>
     *
     * @return õJ
     */
    public String getVolumeColumnName();
    
    /**
     * ttH[}bgT[rXݒ肷B<p>
     * 
     * @param name T[rX
     */
    public void setDateFormatServiceName(ServiceName name);
    
    /**
     * ttH[}bgT[rX擾B<p>
     * 
     * @return T[rX
     */
    public ServiceName getDateFormatServiceName();
    
    /**
     * tJCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setDateColumnIndex(int index);
    
    /**
     * tJCfbNX擾B<p>
     * 
     * @return JCfbNX
     */
    public int getDateColumnIndex();
    
    /**
     * JCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setTimeColumnIndex(int index);
    
    /**
     * JCfbNX擾B<p>
     * 
     * @return JCfbNX
     */ 
    public int getTimeColumnIndex();
    
    /**
     * nlJCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setOpenPriceColumnIndex(int index);
    
    /**
     * nlJCfbNX擾B<p>
     * 
     * @return JCfbNX
     */
    public int getOpenPriceColumnIndex();
    
    /**
     * lJCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setHighPriceColumnIndex(int index);
    
    /**
     * lJCfbNX擾B<p>
     * 
     * @return JCfbNX
     */
    public int getHighPriceColumnIndex();
    
    /**
     * lJCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setLowPriceColumnIndex(int index);
    
    /**
     * lJCfbNX擾B<p>
     * 
     * @return JCfbNX
     */
    public int getLowPriceColumnIndex();
    
    /**
     * IlJCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setClosePriceColumnIndex(int index);
    
    /**
     * IlJCfbNX擾B<p>w
     * 
     * @return JCfbNX
     */
    public int getClostePriceColumnIndex();
    
    /**
     * oJCfbNXݒ肷B<p>
     * 
     * @param index JCfbNX
     */
    public void setVolumeColumnIndex(int index);
    
    /**
     * oJCfbNX擾B<p>
     * 
     * @return JCfbNX
     */
    public int getVolumeColumnIndex();
}
