/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link AbstractTickUnitAdjusterService}MBeanC^tF[XB<p>
 */
public interface AbstractTickUnitAdjusterServiceMBean
    extends ServiceBaseMBean {
    /**
     * \ڐ萔ݒ肷B<p>
     *
     * @param count \ڐ萔
     */
    public void setDisplayGraduationCount(int count);

    /**
     * \ڐ萔擾B<p>
     *
     * @return \ڐ萔
     */
    public int getDisplayGraduationCount();

    /**
     * jbgJEǧ񐔂ݒ肷B<p>
     *
     * @param divisor jbgJEǧ
     */
    public void setUnitCountCommonDivisor(double divisor);

    /**
     * jbgJEǧ񐔂擾B<p>
     *
     * @return jbgJEǧ
     */
    public double getUnitCountCommonDivisor();

    /**
     * cǂݒ肷B<p>
     *
     * @param isDomain true:c/false:
     */
    public void setDomain(boolean isDomain);

    /**
     * cǂ擾B<p>
     *
     * @return true:c/false:
     */
    public boolean isDomain();

    /**
     * ̃CfbNXݒ肷B<p>
     *
     * @param index ̃CfbNX
     */
    public void setAxisIndex(int index);

    /**
     * ̃CfbNX擾B<p>
     *
     * @return ̃CfbNX
     */
    public int getAxisIndex();

    /**
     * TickUnitߌ񐔃}bvT[rXݒ肷B<p>
     * 
     * @param serviceName TickUnitߌ񐔃}bvT[rX
     */
    public void setTickUnitAdjustCommonDivisorMapServiceName(ServiceName serviceName);
    
    /**
     * TickUnitߌ񐔃}bvT[rX擾B<p>
     * 
     * @return TickUnitߌ񐔃}bvT[rX
     */
    public ServiceName getTickUnitAdjustCommonDivisorMapServiceName();
    
    /**
     * ŏ͈̓TCYݒL܂͖ɂB<p>
     * 
     * @param enabled true:L/false:
     */
    public void setAutoRangeMinimumSizeEnabled(boolean enabled);
    
    /**
     * ŏ͈̓TCYݒ肪L擾B<p>
     * 
     * @return true:L/false:
     */
    public boolean getAutoRangeMinimumSizeEnabled();
    
}
