/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.distribute;

import java.util.List;

import jp.ossc.nimbus.core.*;

/**
 * {@link ClusterService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ClusterService
 */
public interface ClusterServiceMBean extends ServiceBaseMBean{
    
    /**
     * ̃NX^ғnɐ؂ւ|̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_CHANGE_OPERATION_SYSTEM = "CLST_00001";
    
    /**
     * ̃NX^ҋ@nɐ؂ւ|̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_CHANGE_STANDBY_SYSTEM = "CLST_00002";
    
    /**
     * ̃NX^ғnɐ؂ւȂ|̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_FAILED_CHANGE_ACTIVE_SYSTEM = "CLST_00003";
    
    /**
     * NX^Ԃ̃bZ[WMɎs|̃ObZ[WIDB<p>
     */
    public static final String MSG_ID_MESSAGE_IO_ERROR = "CLST_00004";
    
    /**
     * NX^gރT[rX̃T[rXݒ肷B<p>
     *
     * @param name T[rX
     */
    public void setTargetServiceName(ServiceName name);
    
    /**
     * NX^gރT[rX̃T[rX擾B<p>
     *
     * @return T[rX
     */
    public ServiceName getTargetServiceName();
    
    /**
     * {@link ClusterListener}T[rX̃T[rXݒ肷B<p>
     *
     * @param names ClusterListenerT[rX̃T[rX
     */
    public void setClusterListenerServiceNames(ServiceName[] names);
    
    /**
     * {@link ClusterListener}T[rX̃T[rX擾B<p>
     *
     * @return ClusterListenerT[rX̃T[rX
     */
    public ServiceName[] getClusterListenerServiceNames();
    
    /**
     * }`LXgO[vIPAhXݒ肷B<p>
     *
     * @param ip IPAhX
     */
    public void setMulticastGroupAddress(String ip);
    
    /**
     * }`LXgO[vIPAhX擾B<p>
     *
     * @return IPAhX
     */
    public String getMulticastGroupAddress();
    
    /**
     * }`LXgO[ṽ|[gԍݒ肷B<p>
     * ftHǵA1500B<br>
     *
     * @param port |[gԍ
     */
    public void setMulticastPort(int port);
    
    /**
     * }`LXgO[ṽ|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getMulticastPort();
    
    /**
     * jLXgo[IPAhXݒ肷B<p>
     *
     * @param addresses IPAhX̔z
     */
    public void setUnicastMemberAddresses(String[] addresses);
    
    /**
     * jLXgo[IPAhX擾B<p>
     *
     * @return IPAhX̔z
     */
    public String[] getUnicastMemberAddresses();
    
    /**
     * jLXg̃|[gԍݒ肷B<p>
     * ftHǵA1500B<br>
     *
     * @param port |[gԍ
     */
    public void setUnicastPort(int port);
    
    /**
     * jLXg̃|[gԍ擾B<p>
     *
     * @return |[gԍ
     */
    public int getUnicastPort();
    
    /**
     * pPbg̎Mobt@TCYݒ肷B<p>
     * ftHǵA1024oCgB<br>
     *
     * @param size obt@TCY
     */
    public void setReceiveBufferSize(int size);
    
    /**
     * pPbg̎Mobt@TCY擾B<p>
     *
     * @return obt@TCY
     */
    public int getReceiveBufferSize();
    
    /**
     * }`LXgpPbg̗LԂݒ肷B<p>
     *
     * @param ttl L
     */
    public void setTimeToLive(int ttl);
    
    /**
     * }`LXgpPbg̗LԂ擾B<p>
     *
     * @return L
     */
    public int getTimeToLive();
    
    /**
     * [JIPAhXݒ肷B<p>
     *
     * @param ip IPAhX
     */
    public void setLocalAddress(String ip);
    
    /**
     * [JIPAhX擾B<p>
     *
     * @return IPAhX
     */
    public String getLocalAddress();
    
    /**
     * gIPAhXȊO̎ʕ⑫ݒ肷B<p>
     *
     * @param opt ʕ⑫
     */
    public void setOption(java.io.Serializable opt);
    
    /**
     * gIPAhXȊO̎ʕ⑫擾B<p>
     *
     * @return ʕ⑫
     */
    public java.io.Serializable getOption();
    
    /**
     * ׂ̃NX^T[rXƃn[gr[gsԊu[ms]ݒ肷B<p>
     * ftHǵA1000[ms]B<br>
     *
     * @param interval n[gr[gsԊu[ms]
     */
    public void setHeartBeatInterval(long interval);
    
    /**
     * ׂ̃NX^T[rXƃn[gr[gsԊu[ms]擾B<p>
     *
     * @return n[gr[gsԊu[ms]
     */
    public long getHeartBeatInterval();
    
    /**
     * ׂ̃NX^T[rXɃn[gr[gNGXg̃^CAEg[ms]ݒ肷B<p>
     * ftHǵA500[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setHeartBeatResponseTimeout(long timeout);
    
    /**
     * ׂ̃NX^T[rXɃn[gr[gNGXg̃^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getHeartBeatResponseTimeout();
    
    /**
     * ׂ̃NX^T[rXƂ̃n[gr[gɎsꍇɁA肪񂾂ƌȂ܂ł̃gC񐔂ݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param count gC
     */
    public void setHeartBeatRetryCount(int count);
    
    /**
     * ׂ̃NX^T[rXƂ̃n[gr[gɎsꍇɁA肪񂾂ƌȂ܂ł̃gC񐔂擾B<p>
     *
     * @return gC
     */
    public int getHeartBeatRetryCount();
    
    /**
     * T[rXNɃNX^ɎQ郊NGXgs̃^CAEg[ms]ݒ肷B<p>
     * ftHǵA500[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setAddMemberResponseTimeout(long timeout);
    
    /**
     * T[rXNɃNX^ɎQ郊NGXgs̃^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getAddMemberResponseTimeout();
    
    /**
     * MpPbgĂꍇɁAꂽcpPbgƂ݂Ȃ^CAEg[ms]ݒ肷B<p>
     * ftHǵA500[ms]B<br>
     *
     * @param timeout ^CAEg[ms]
     */
    public void setLostTimeout(long timeout);
    
    /**
     * MpPbgĂꍇɁAꂽcpPbgƂ݂Ȃ^CAEg[ms]擾B<p>
     *
     * @return ^CAEg[ms]
     */
    public long getLostTimeout();
    
    /**
     * NX^NCAgǂݒ肷B<p>
     * NX^NCAgɂȂꍇ́Atrueɐݒ肷BftHǵAfalseB<br>
     * NX^NCAǵANX^̃oɂ͎QNX^̏󋵒ʒm̂ݎ󂯂B<br>
     *
     * @param isClient NX^NCAgɂȂꍇ́Atrue
     */
    public void setClient(boolean isClient);
    
    /**
     * NX^NCAgǂ𔻒肷B<p>
     *
     * @return truȅꍇANX^NCAg
     */
    public boolean isClient();
    
    /**
     * T[rX̊JnɁANX^ɎQ邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isJoin Qꍇtrue
     */
    public void setJoinOnStart(boolean isJoin);
    
    /**
     * T[rX̊JnɁANX^ɎQ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAQ
     */
    public boolean isJoinOnStart();
    
    /**
     * NX^ɎQĂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAQĂ
     */
    public boolean isJoin();
    
    /**
     * NX^̃Cł邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇC
     */
    public boolean isMain();
    
    /**
     * ݂̃NX^oUID̃Xg擾B<p>
     *
     * @return ݂̃NX^o
     */
    public List<? extends Object> getMembers();
    
    /**
     * ̃T[rXUID擾B<p>
     *
     * @return UID
     */
    public Object getUID();
    
    /**
     * NX^ɎQB<p>
     */
    public void join() throws Exception;
    
    /**
     * NX^痣EB<p>
     */
    public void leave();
    
    /**
     * 1bZ[W̍ő啪擾B<p>
     *
     * @return ő啪
     */
    public int getMaxWindowCount();
}