/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.codemaster;

import java.util.Map;
import java.util.Properties;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultCodeMasterFinderService}MBeanC^tF[XB<p>
 *
 * @author S.Yoshihara
 */
public interface DefaultCodeMasterFinderServiceMBean
 extends ServiceBaseMBean, CodeMasterFinder{
    
    /**
     * }X^zݒ肷B<p>
     *
     * @param names }X^̔z
     */
    public void setMasterNames(String[] names);
    
    /**
     * }X^z擾B<p>
     *
     * @return }X^̔z
     */
    public String[] getMasterNames();
    
    /**
     * }X^擾̂߂{@link jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlow BeanFlow}Ăяos߂{@link jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowFactory BeanFlowFactory}T[rX̃T[rXݒ肷B<p>
     * ̑{@link #setFacadeCallerServiceName(ServiceName)}̂ǂ炩́AKݒ肵Ȃ΂ȂȂB<br>
     * 
     * @param name BeanFlowFactoryT[rX̃T[rX
     */
    public void setBeanFlowFactoryServiceName(ServiceName name);
    
    /**
     * }X^擾̂߂{@link jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlow BeanFlow}Ăяos߂{@link jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowFactory BeanFlowFactory}T[rX̃T[rX擾B<p>
     * 
     * @return BeanFlowFactoryT[rX̃T[rX
     */
    public ServiceName getBeanFlowFactoryServiceName();
    
    /**
     * JMSgsbNMjavax.jms.TopicSubscriber𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory}T[rX̃T[rXݒ肷B<p>
     * JMSgsbNł̃}X^XVsꍇɎgpBJMSgsbNł̃}X^XVsȂꍇ́Aݒ肷Kv͂ȂB<br>
     *
     * @param name JMSMessageConsumerFactoryT[rX̃T[rX
     */
    public void setJMSTopicSubscriberFactoryServiceName(ServiceName name);
    
    /**
     * JMSgsbNMjavax.jms.TopicSubscriber𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSMessageConsumerFactoryT[rX̃T[rX
     */
    public ServiceName getJMSTopicSubscriberFactoryServiceName();
    
    /**
     * JMSgsbNMjavax.jms.TopicSubscriber𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory}T[rX̃T[rXݒ肷B<p>
     * JMSgsbNł̃}X^XVsꍇɎgpBJMSgsbNł̃}X^XVsȂꍇ́Aݒ肷Kv͂ȂB<br>
     *
     * @param names JMSMessageConsumerFactoryT[rX̃T[rXz
     */
    public void setJMSTopicSubscriberFactoryServiceNames(ServiceName[] names);
    
    /**
     * JMSgsbNMjavax.jms.TopicSubscriber𐶐{@link jp.ossc.nimbus.service.jms.JMSMessageConsumerFactory}T[rX̃T[rX擾B<p>
     *
     * @return JMSMessageConsumerFactoryT[rX̃T[rXz
     */
    public ServiceName[] getJMSTopicSubscriberFactoryServiceNames();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageReceiver MessageReceiver}T[rX{@link jp.ossc.nimbus.service.publish.Message Message}Mۂ̃TuWFNgݒ肷B<p>
     *
     * @param subject TuWFNg
     */
    public void setSubjects(String[] subject);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.MessageReceiver MessageReceiver}T[rX{@link jp.ossc.nimbus.service.publish.Message Message}Mۂ̃TuWFNg擾B<p>
     *
     * @return TuWFNg
     */
    public String[] getSubjects();
    
    /**
     * {@link jp.ossc.nimbus.service.publish.Message Message}M{@link jp.ossc.nimbus.service.publish.MessageReceiver MessageReceiver}T[rX̃T[rXݒ肷B<p>
     * Messageł̃}X^XVsꍇɎgpBMessageł̃}X^XVsȂꍇ́Aݒ肷Kv͂ȂB<br>
     *
     * @param name MessageReceiverT[rX̃T[rX
     */
    public void setMessageReceiverServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.publish.Message Message}M{@link jp.ossc.nimbus.service.publish.MessageReceiver MessageReceiver}T[rX̃T[rX擾B<p>
     *
     * @return MessageReceiverT[rX̃T[rX
     */
    public ServiceName getMessageReceiverServiceName();
    
    /**
     * JMSgsbNŃ}X^XVsꍇ̃}X^ƒʒm}X^̃}bsOݒ肷B<p>
     * }X^ƒʒm}X^ꍇ́Aݒ肷Kv͂ȂB<br>
     *
     * @param mapping }X^ƒʒm}X^̃}bsOBʒm}X^=}X^1,}X^2,...
     */
    public void setNotifyMasterNameMapping(Properties mapping);
    
    /**
     * JMSgsbNŃ}X^XVsꍇ̃}X^ƒʒm}X^̃}bsO擾B<p>
     *
     * @return }X^ƒʒm}X^̃}bsOBʒm}X^=}X^1,}X^2,...
     */
    public Properties getNotifyMasterNameMapping();
    
    /**
     * T[rX̊JnɎ擾}X^̃}X^zݒ肷B<p>
     * w肵Ȃꍇ́ASẴ}X^T[rX̊JnɎ擾B<br>
     *
     * @param names }X^z
     */
    public void setStartMasterNames(String[] names);
    
    /**
     * T[rX̊JnɎ擾}X^̃}X^z擾B<p>
     *
     * @return }X^z
     */
    public String[] getStartMasterNames();
    
    /**
     * T[rX̊JnɎ擾Ȃ}X^̃}X^zݒ肷B<p>
     * w肵Ȃꍇ́ASẴ}X^T[rX̊JnɎ擾B<br>
     *
     * @param names }X^z
     */
    public void setNotStartMasterNames(String[] names);
    
    /**
     * T[rX̊JnɎ擾Ȃ}X^̃}X^z擾B<p>
     *
     * @return }X^z
     */
    public String[] getNotStartMasterNames();
    
    /**
     * T[rX̊JnɎ擾}X^̃}X^Ɠ̓IuWFNg̃}bsOݒ肷B<p>
     * ͂KvȂ}X^̏ꍇ́A}bsOݒ肷Kv͂ȂB<br>
     *
     * @param map }X^Ɠ̓IuWFNg̃}bv
     */
    public void setStartMasterInputMap(Map<String, Object> map);
    
    /**
     * T[rX̊JnɎ擾}X^̃}X^Ɠ̓IuWFNg̃}bsO擾B<p>
     *
     * @return }X^Ɠ̓IuWFNg̃}bv
     */
    public Map<String, Object> getStartMasterInputMap();
}
