/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import java.io.IOException;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.io.Externalizer;

/**
 * LbV}bvT[rXB<p>
 * ȉɁALbVIuWFNgɕێLbV}bvT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="SerializedMemoryCacheMap"
 *                  code="jp.ossc.nimbus.service.cache.SerializedMemoryCacheMapService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class SerializedMemoryCacheMapService<K, V> extends AbstractCacheMapService<K, V>
 implements java.io.Serializable, SerializedMemoryCacheMapServiceMBean<K, V>{
    
    private static final long serialVersionUID = 3483316909396633967L;
    
    private ServiceName externalizerServiceName;
    private Externalizer<V> externalizer;
    
    private ServiceName persistCacheMapServiceName;
    
    public void setPersistCacheMapServiceName(ServiceName name){
        persistCacheMapServiceName = name;
    }
    public ServiceName getPersistCacheMapServiceName(){
        return persistCacheMapServiceName;
    }
    
    @Override
    public void setExternalizerServiceName(ServiceName name){
        externalizerServiceName = name;
    }
    @Override
    public ServiceName getExternalizerServiceName(){
        return externalizerServiceName;
    }
    
    public void setExternalizer(Externalizer<V> ext){
        externalizer = ext;
    }
    public Externalizer<V> getExternalizer(){
        return externalizer;
    }
    
    @Override
    public void startService() throws Exception{
        if(externalizerServiceName != null){
            externalizer = ServiceManagerFactory
                .getServiceObject(externalizerServiceName);
        }
        if(persistCacheMapServiceName != null){
            CacheMap<K, V> persistCacheMap = ServiceManagerFactory.getServiceObject(persistCacheMapServiceName);
            putAll(persistCacheMap);
        }
    }
    
    public void stopService() throws Exception{
        if(persistCacheMapServiceName != null){
            CacheMap<K, V> persistCacheMap = ServiceManagerFactory.getServiceObject(persistCacheMapServiceName);
            persistCacheMap.clear();
            persistCacheMap.putAll(this);
        }
    }
    
    /**
     * L[tLbVQƂ𐶐B<p>
     *
     * @param key LbṼL[
     * @param obj LbVIuWFNg
     * @return L[tLbVQ
     */
    @Override
    protected KeyCachedReference<K, V> createKeyCachedReference(
        K key,
        V obj
    ){
        try{
            return externalizer == null
                ? new SerializeKeyCachedReference<K, V>(key, obj)
                    : new SerializeKeyCachedReference<K, V>(key, obj, externalizer);
        }catch(IOException e){
            throw new IllegalArgumentException(e.toString());
        }
    }
}
