/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.cache;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceManagerFactory;

/**
 * LbV}bvT[rXB<p>
 * ȉɁALbVIuWFNgɕێLbV}bvT[rX̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="MemoryCacheMap"
 *                  code="jp.ossc.nimbus.service.cache.MemoryCacheMapService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 */
public class MemoryCacheMapService<K, V> extends AbstractCacheMapService<K, V>
 implements java.io.Serializable, PersistableCache, MemoryCacheMapServiceMBean<K, V>{
    
    private static final long serialVersionUID = 1595164377209904186L;
    
    private ServiceName persistCacheMapServiceName;
    private boolean isLoadOnStart = true;
    private boolean isSaveOnStop = true;
    
    public void setPersistCacheMapServiceName(ServiceName name){
        persistCacheMapServiceName = name;
    }
    public ServiceName getPersistCacheMapServiceName(){
        return persistCacheMapServiceName;
    }
    
    public void setLoadOnStart(boolean isLoad){
        isLoadOnStart = isLoad;
    }
    public boolean isLoadOnStart(){
        return isLoadOnStart;
    }
    
    public void setSaveOnStop(boolean isSave){
        isSaveOnStop = isSave;
    }
    public boolean isSaveOnStop(){
        return isSaveOnStop;
    }
    
    public void startService() throws Exception{
        if(isLoadOnStart){
            load();
        }
    }
    
    public void stopService() throws Exception{
        if(isSaveOnStop){
            save();
        }
    }
    
    /**
     * L[tLbVQƂ𐶐B<p>
     *
     * @param key LbṼL[
     * @param obj LbVIuWFNg
     * @return L[tLbVQ
     */
    protected KeyCachedReference<K, V> createKeyCachedReference(
        K key,
        V obj
    ){
        return new DefaultKeyCachedReference<K, V>(key, obj);
    }
    
    public synchronized void load() throws Exception{
        if(persistCacheMapServiceName != null){
            CacheMap<K, V> persistCacheMap = ServiceManagerFactory.getServiceObject(persistCacheMapServiceName);
            clear();
            putAll(persistCacheMap);
        }
    }
    
    public synchronized void save() throws Exception{
        if(persistCacheMapServiceName != null){
            CacheMap<K, V> persistCacheMap = ServiceManagerFactory.getServiceObject(persistCacheMapServiceName);
            persistCacheMap.clear();
            persistCacheMap.putAll(this);
        }
    }
}
