/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.invoker;

import jp.ossc.nimbus.core.*;

/**
 * {@link ClusterInvokerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see ClusterInvokerService
 */
public interface ClusterInvokerServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * {@link jp.ossc.nimbus.service.aop.KeepAliveCheckInvoker KeepAliveCheckInvoker}I{@link jp.ossc.nimbus.service.distribute.KeepAliveCheckerSelector KeepAliveCheckerSelector}T[rX̃T[rXݒ肷B<p>
     *
     * @param name KeepAliveCheckerSelectorT[rX̃T[rX
     */
    public void setKeepAliveCheckerSelectorServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.aop.KeepAliveCheckInvoker KeepAliveCheckInvoker}I{@link jp.ossc.nimbus.service.distribute.KeepAliveCheckerSelector KeepAliveCheckerSelector}T[rX̃T[rXݒ肷B<p>
     *
     * @return KeepAliveCheckerSelectorT[rX̃T[rX
     */
    public ServiceName getKeepAliveCheckerSelectorServiceName();
    
    /**
     * gCÕNXƂ̏ݒ肷B<p>
     * ̏ݒ肵Ȃꍇ́A{@link jp.ossc.nimbus.service.aop.invoker.InvokeException.service.proxy.RemoteServiceCallException}Lb`ꍇɃgCB<br>
     * ́AThe Apache Jakarta Project Commons Jexl(http://jakarta.apache.org/commons/jexl/)gpB<br>
     * ÕvpeBQƂꍇ́AvpeB\镶"prop:get(value, "vpeB")Ŏw肷BŌAvpeB̊TÓAJava Beans̃vpeB̊TOLA{@link jp.ossc.nimbus.beans.PropertyFactory PropertyFactory}̋Kɏ]B<br>
     *
     * @param conditions ONX:iKvȂꍇ́A:ȉȗ\j̕z
     */
    public void setExceptionConditions(String[] conditions);
    
    /**
     * gCÕNXƂ̏擾B<p>
     *
     * @return ONX:iKvȂꍇ́A:ȉȗ\j̕z
     */
    public String[] getExceptionConditions();
    
    /**
     * gC񐔂ݒ肷B<p>
     * ftHǵA0ŃgCȂB<br>
     *
     * @param count gC
     */
    public void setMaxRetryCount(int count);
    
    /**
     * gC񐔂擾B<p>
     *
     * @return gC
     */
    public int getMaxRetryCount();
    
    /**
     * gCԊu[ms]ݒ肷B<p>
     * ftHǵA0ŊԊuɃgCB<br>
     *
     * @param interval gCԊu[ms]
     */
    public void setRetryInterval(long interval);
    
    /**
     * gCԊu[ms]擾B<p>
     *
     * @return gCԊu[ms]
     */
    public long getRetryInterval();
    
    /**
     * Ăяo_ŐĂSĂ{@link jp.ossc.nimbus.service.aop.KeepAliveCheckInvoker KeepAliveCheckInvoker}Ăяo悤ɂ邩ǂݒ肷B<p>
     * truȅꍇAĂяo_ŐĂSĂKeepAliveCheckInvokerĂяoB̍ہAgC@\͖ƂȂAǂꂩPKeepAliveCheckInvokeřĂяoŗOƁAŏIB<br>
     *
     * @param isBroadcast SĂKeepAliveCheckInvokerĂяoꍇ́Atrue
     */
    public void setBroadcast(boolean isBroadcast);
    
    /**
     * Ăяo_ŐĂSĂ{@link jp.ossc.nimbus.service.aop.KeepAliveCheckInvoker KeepAliveCheckInvoker}Ăяo悤ɂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇASĂKeepAliveCheckInvokerĂяo
     */
    public boolean isBroadcast();
}