/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import javax.servlet.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.service.context.*;
import jp.ossc.nimbus.service.journal.*;
import jp.ossc.nimbus.util.converter.*;

/**
 * T[ubgNGXgC^[Zv^B<p>
 * {@link javax.servlet.ServletRequest}{@link jp.ossc.nimbus.util.converter.Converter#convert(Object) Converter#convert(Object)}ŔCӂ̃IuWFNgɕϊāANGXgɐݒ肷B<br>
 *
 * @author M.Takata
 */
public class ServletRequestExchangeInterceptorService
 extends ServletFilterInterceptorService
 implements ServletRequestExchangeInterceptorServiceMBean{
    
    private static final long serialVersionUID = 2844563371397261067L;
    
    protected ServiceName converterServiceName;
    protected Converter converter;
    
    protected ServiceName threadContextServiceName;
    protected Context<Object, Object> threadContext;
    
    protected ServiceName journalServiceName;
    protected Journal journal;
    
    protected ServiceName exchangeEditorFinderServiceName;
    protected EditorFinder exchangeEditorFinder;
    
    protected String exchangeJournalKey = DEFAULT_EXCHANGE_JOURNAL_KEY;
    protected String requestObjectJournalKey = DEFAULT_REQUEST_OBJECT_JOURNAL_KEY;
    protected String exceptionJournalKey = DEFAULT_EXCEPTION_JOURNAL_KEY;
    
    protected String requestObjectAttributeName
         = DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    
    protected String requestObjectContextKey
         = DEFAULT_REQUEST_OBJECT_CONTEXT_KEY;
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setConverterServiceName(ServiceName name){
        converterServiceName = name;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getConverterServiceName(){
        return converterServiceName;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setThreadContextServiceName(ServiceName name){
        threadContextServiceName = name;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getThreadContextServiceName(){
        return threadContextServiceName;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setJournalServiceName(ServiceName name){
        journalServiceName = name;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getJournalServiceName(){
        return journalServiceName;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeEditorFinderServiceName(ServiceName name){
        exchangeEditorFinderServiceName = name;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public ServiceName getExchangeEditorFinderServiceName(){
        return exchangeEditorFinderServiceName;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setExchangeJournalKey(String key){
        exchangeJournalKey = key;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public String getExchangeJournalKey(){
        return exchangeJournalKey;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setRequestObjectJournalKey(String key){
        requestObjectJournalKey = key;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public String getRequestObjectJournalKey(){
        return requestObjectJournalKey;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setExceptionJournalKey(String key){
        exceptionJournalKey = key;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public String getExceptionJournalKey(){
        return exceptionJournalKey;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setRequestObjectAttributeName(String name){
        requestObjectAttributeName = name;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public String getRequestObjectAttributeName(){
        return requestObjectAttributeName;
    }
    
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public void setRequestObjectContextKey(String key){
        requestObjectContextKey = key;
    }
    // ServletRequestExchangeInterceptorServiceMBean JavaDoc
    public String getRequestObjectContextKey(){
        return requestObjectContextKey;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        if(converterServiceName == null
             && converter == null){
            throw new IllegalArgumentException("It is necessary to specify ConverterServiceName or Converter.");
        }
        if(converterServiceName != null){
            converter = ServiceManagerFactory
                .getServiceObject(converterServiceName);
        }
        
        if(threadContextServiceName != null){
            threadContext = ServiceManagerFactory
                .getServiceObject(threadContextServiceName);
        }
        
        if(journalServiceName != null){
            journal = ServiceManagerFactory
                .getServiceObject(journalServiceName);
        }
        
        if(exchangeEditorFinderServiceName != null){
            exchangeEditorFinder = ServiceManagerFactory
                .getServiceObject(
                    exchangeEditorFinderServiceName
                );
        }
    }
    
    /**
     * T[ubgNGXgvIuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.Converter Converter}T[rXݒ肷B<p>
     *
     * @param conv ConverterT[rX
     */
    public void setConverter(Converter conv){
        converter = conv;
    }
    
    /**
     * T[ubgNGXgvIuWFNgɕϊ{@link jp.ossc.nimbus.util.converter.Converter Converter}T[rX擾B<p>
     *
     * @return ConverterT[rX
     */
    public Converter getConverter(){
        return converter;
    }
    
    /**
     * vIuWFNg悹{@link jp.ossc.nimbus.service.context.Context Context}T[rXݒ肷B<p>
     *
     * @param context ContextT[rX
     */
    public void setThreadContext(Context<Object, Object> context){
        threadContext = context;
    }
    
    /**
     * vIuWFNg悹{@link jp.ossc.nimbus.service.context.Context Context}T[rX擾B<p>
     *
     * @return ContextT[rX
     */
    public Context<Object, Object> getThreadContext(){
        return threadContext;
    }
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rXݒ肷B<p>
     *
     * @param journal JournalT[rX
     */
    public void setJournal(Journal journal){
        this.journal = journal;
    }
    
    /**
     * W[io͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX擾B<p>
     *
     * @return JournalT[rX
     */
    public Journal getJournal(){
        return journal;
    }
    
    /**
     * W[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rXݒ肷B<p>
     *
     * @param finder EditorFinderT[rX
     */
    public void setExchangeEditorFinder(EditorFinder finder){
        exchangeEditorFinder = finder;
    }
    
    /**
     * W[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.JournalEditor JournalEditor}{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX擾B<p>
     *
     * @return EditorFinderT[rX
     */
    public EditorFinder getExchangeEditorFinder(){
        return exchangeEditorFinder;
    }
    
    /**
     * ConvertergăT[ubgNGXgƓIuWFNǧsB<p>
     * ServletRequestConverterœ̃IuWFNgɕϊāANGXg̑ɐݒ肵ÃC^[Zv^ĂяoB<br>
     * T[rXJnĂȂꍇ́AɎ̃C^[Zv^ĂяoB<br>
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return Ăяoʂ̖߂l
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invokeFilter(
        ServletFilterInvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() != State.STARTED){
            return chain.invokeNext(context);
        }
        try{
            if(journal != null){
                journal.startJournal(exchangeJournalKey, exchangeEditorFinder);
            }
            final ServletRequest request = context.getServletRequest();
            Object requestObj = null;
            try{
                requestObj = converter.convert(request);
            }catch(Exception e){
                throw new InputExchangeException(e);
            }
            if(journal != null){
                journal.addInfo(
                    requestObjectJournalKey,
                    requestObj
                );
            }
            request.setAttribute(requestObjectAttributeName, requestObj);
                
            final Object ret = chain.invokeNext(context);
            return ret;
        }catch(Throwable th){
           if(journal != null){
                journal.addInfo(
                    exceptionJournalKey,
                    th
                );
           }
           throw th;
        }finally{
            if(journal != null){
                journal.endJournal();
            }
        }
    }
}