/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Properties;

/**
 * {@link HttpServletRequestCheckInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see HttpServletRequestCheckInterceptorService
 */
public interface HttpServletRequestCheckInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * NGXgwb_Content-Length̍őlݒ肷B<p>
     * ݒ肵Ȃꍇ́AContent-Length̍ől̓`FbNȂB<br>
     *
     * @param max Content-Length̍ől
     */
    public void setMaxContentLength(int max);
    
    /**
     * NGXgwb_Content-Length̍ől擾B<p>
     *
     * @return Content-Length̍ől
     */
    public int getMaxContentLength();
    
    /**
     * NGXgwb_Content-Length̍ŏlݒ肷B<p>
     * ݒ肵Ȃꍇ́AContent-Length̍ŏl̓`FbNȂB<br>
     *
     * @param min Content-Length̍ŏl
     */
    public void setMinContentLength(int min);
    
    /**
     * NGXgwb_Content-Length̍ŏl擾B<p>
     *
     * @return Content-Length̍ŏl
     */
    public int getMinContentLength();
    
    /**
     * NGXgwb_Content-Typenullł鎖e邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isAllow Content-Typenullł鎖eꍇAtrue
     */
    public void setAllowNullContentType(boolean isAllow);
    
    /**
     * NGXgwb_Content-Typenullł鎖e邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAContent-Typenullł鎖e
     */
    public boolean isAllowNullContentType();
    
    /**
     * NGXgwb_Content-Type̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AContent-Type̒l̓`FbNȂB<br>
     *
     * @param types Content-Type̒lƂėLȒl̕z
     */
    public void setValidContentTypes(String[] types);
    
    /**
     * NGXgwb_Content-Type̒lƂėLȒl擾B<p>
     *
     * @return Content-Type̒lƂėLȒl̕z
     */
    public String[] getValidContentTypes();
    
    /**
     * NGXgwb_Content-Type̒lƂĖȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AContent-Type̒l̓`FbNȂB<br>
     *
     * @param types Content-Type̒lƂĖȒl̕z
     */
    public void setInvalidContentTypes(String[] types);
    
    /**
     * NGXgwb_Content-Type̒lƂĖȒl擾B<p>
     *
     * @return Content-Type̒lƂĖȒl̕z
     */
    public String[] getInvalidContentTypes();
    
    /**
     * NGXg{fB̕GR[fBOw肳ĂȂe邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isAllow NGXg{fB̕GR[fBOw肳ĂȂeꍇAtrue
     */
    public void setAllowNullCharacterEncoding(boolean isAllow);
    
    /**
     * NGXg{fB̕GR[fBOw肳ĂȂe邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇANGXg{fB̕GR[fBOw肳ĂȂe
     */
    public boolean isAllowNullCharacterEncoding();
    
    /**
     * NGXg{fB̕GR[fBOƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AGR[fBO̓`FbNȂB<br>
     *
     * @param encodings GR[fBOƂėLȒl̕z
     */
    public void setValidCharacterEncodings(String[] encodings);
    
    /**
     * NGXg{fB̕GR[fBOƂėLȒl擾B<p>
     *
     * @return GR[fBOƂėLȒl̕z
     */
    public String[] getValidCharacterEncodings();
    
    /**
     * NGXg{fB̕GR[fBOƂĖȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AGR[fBO̓`FbNȂB<br>
     *
     * @param encodings GR[fBOƂĖȒl̕z
     */
    public void setInvalidCharacterEncodings(String[] encodings);
    
    /**
     * NGXg{fB̕GR[fBOƂĖȒl擾B<p>
     *
     * @return GR[fBOƂĖȒl̕z
     */
    public String[] getInvalidCharacterEncodings();
    
    /**
     * NGXgwb_Accept-Languagenullł鎖e邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isAllow Accept-Languagenullł鎖eꍇAtrue
     */
    public void setAllowNullLocale(boolean isAllow);
    
    /**
     * NGXgwb_Accept-Languagenullł鎖e邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAAccept-Languagenullł鎖e
     */
    public boolean isAllowNullLocale();
    
    /**
     * NGXgwb_Accept-Language̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AAccept-Language̒l̓`FbNȂB<br>
     *
     * @param locales Accept-Language̒lƂėLȒliK\j̕z
     */
    public void setValidLocales(String[] locales);
    
    /**
     * NGXgwb_Accept-Language̒lƂėLȒl擾B<p>
     *
     * @return Accept-Language̒lƂėLȒliK\j̕z
     */
    public String[] getValidLocales();
    
    /**
     * NGXg̃vgR̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AvgR̒l̓`FbNȂB<br>
     *
     * @param protocols vgR̒lƂėLȒliK\j̕z
     */
    public void setValidProtocols(String[] protocols);
    
    /**
     * NGXg̃vgR̒lƂėLȒl擾B<p>
     *
     * @return vgR̒lƂėLȒliK\j̕z
     */
    public String[] getValidProtocols();
    
    /**
     * NCAgIPAhX̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AIPAhX̒l̓`FbNȂB<br>
     *
     * @param addrs IPAhX̒lƂėLȒliK\j̕z
     */
    public void setValidRemoteAddrs(String[] addrs);
    
    /**
     * NCAgIPAhX̒lƂėLȒl擾B<p>
     *
     * @return IPAhX̒lƂėLȒliK\j̕z
     */
    public String[] getValidRemoteAddrs();
    
    /**
     * NCAg̃zXgƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AzXg̓`FbNȂB<br>
     *
     * @param hosts zXgƂėLȒliK\j̕z
     */
    public void setValidRemoteHosts(String[] hosts);
    
    /**
     * NCAg̃zXgƂėLȒl擾B<p>
     *
     * @return zXgƂėLȒliK\j̕z
     */
    public String[] getValidRemoteHosts();
    
    /**
     * NCAg̃|[gԍƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́A|[gԍ̓`FbNȂB<br>
     *
     * @param ports |[gԍƂėLȒl̔z
     */
    public void setValidRemotePorts(int[] ports);
    
    /**
     * NCAg̃|[gԍƂėLȒl擾B<p>
     *
     * @return |[gԍƂėLȒl̔z
     */
    public int[] getValidRemotePorts();
    
    /**
     * NGXgURL̃XL[}̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AXL[}̒l̓`FbNȂB<br>
     *
     * @param schemata XL[}̒lƂėLȒl̕z
     */
    public void setValidSchemata(String[] schemata);
    
    /**
     * NGXgURL̃XL[}̒lƂėLȒl擾B<p>
     *
     * @return XL[}̒lƂėLȒl̕z
     */
    public String[] getValidSchemata();
    
    /**
     * NGXgURL̃zXg̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́AzXg̒l̓`FbNȂB<br>
     *
     * @param names zXg̒lƂėLȒliK\j̕z
     */
    public void setValidServerNames(String[] names);
    
    /**
     * NGXgURL̃zXg̒lƂėLȒl擾B<p>
     *
     * @return zXg̒lƂėLȒliK\j̕z
     */
    public String[] getValidServerNames();
    
    /**
     * HTTPNGXg̃\bh̒lƂėLȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́A\bh̒l̓`FbNȂB<br>
     *
     * @param methods \bh̒lƂėLȒl̕z
     */
    public void setValidMethods(String[] methods);
    
    /**
     * HTTPNGXg̃\bh̒lƂėLȒl擾B<p>
     *
     * @return \bh̒lƂėLȒl̕z
     */
    public String[] getValidMethods();
    
    /**
     * HTTPNGXg̃\bh̒lƂĖȒlݒ肷B<p>
     * ݒ肵Ȃꍇ́A\bh̒l̓`FbNȂB<br>
     *
     * @param methods \bh̒lƂĖȒl̕z
     */
    public void setInvalidMethods(String[] methods);
    
    /**
     * HTTPNGXg̃\bh̒lƂĖȒl擾B<p>
     *
     * @return \bh̒lƂĖȒl̕z
     */
    public String[] getInvalidMethods();
    
    /**
     * Cӂ̃NGXgwb_̒lƂėLȒlݒ肷B<p>
     *
     * @param cond Cӂ̃NGXgwb_ƗLȒliK\j̃}bsOBNGXgwb_=liK\j
     */
    public void setHeaderEquals(Properties cond);
    
    /**
     * Cӂ̃NGXgwb_̒lƂėLȒl擾B<p>
     *
     * @return Cӂ̃NGXgwb_ƗLȒliK\j̃}bsO
     */
    public Properties getHeaderEquals();
    
    /**
     * `FbNG[ɂȂꍇɕԂHTTPX|X̃Xe[^Xݒ肷B<p>
     * ftHǵA400B<br>
     * {@link #isThrowOnError()}truȅꍇ́A̐ݒ͖łB<br>
     *
     * @param status HTTPX|X̃Xe[^X
     */
    public void setErrorStatus(int status);
    
    /**
     * `FbNG[ɂȂꍇɕԂHTTPX|X̃Xe[^X擾B<p>
     *
     * @return HTTPX|X̃Xe[^X
     */
    public int getErrorStatus();
    
    /**
     * `FbNG[ɂȂꍇɗOthrow邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isThrow `FbNG[ɂȂꍇɗOthrowꍇAtrue
     */
    public void setThrowOnError(boolean isThrow);
    
    /**
     * `FbNG[ɂȂꍇɗOthrow邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA`FbNG[ɂȂꍇɗOthrow
     */
    public boolean isThrowOnError();
}
