/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import java.util.Map;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link DefaultExceptionHandlerService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see DefaultExceptionHandlerService
 */
public interface DefaultExceptionHandlerServiceMBean
 extends ServiceBaseMBean{
    
    /**
     * OW[iɏo͂ۂ̃W[iL[̃ftHglB<p>
     */
    public static final String DEFAULT_EXCEPTION_JOURNAL_KEY = "Exception";
    
    /**
     * OW[iɏo͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     * ݒ肵Ȃꍇ́AW[io͂ȂB<br>
     *
     * @param name JournalT[rX̃T[rX
     */
    public void setJournalServiceName(ServiceName name);
    
    /**
     * OW[iɏo͂{@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B<p>
     *
     * @return JournalT[rX̃T[rX
     */
    public ServiceName getJournalServiceName();
    
    /**
     * OW[iɏo͂ۂ̃W[ĩL[ݒ肷B<p>
     * ftHgł́A{@link #DEFAULT_EXCEPTION_JOURNAL_KEY}B<br>
     *
     * @param key ÕW[iL[
     */
    public void setExceptionJournalKey(String key);
    
    /**
     * OW[iɏo͂ۂ̃W[ĩL[擾B<p>
     *
     * @return ÕW[iL[
     */
    public String getExceptionJournalKey();
    
    /**
     * OOɏo͂ۂ̃bZ[WIDݒ肷B<p>
     * ݒ肵Ȃꍇ́AOo͂ȂB<br>
     *
     * @param id OOɏo͂ۂ̃bZ[WID
     */
    public void setLogMessageCode(String id);
    
    /**
     * OOɏo͂ۂ̃bZ[WID擾B<p>
     *
     * @return OOɏo͂ۂ̃bZ[WID
     */
    public String getLogMessageCode();
    
    /**
     * OOɏo͂ۂ̖ߍ݃p[^ݒ肷B<p>
     *
     * @param args OOɏo͂ۂ̖ߍ݃p[^
     */
    public void setLogMessageArguments(String[] args);
    
    /**
     * OOɏo͂ۂ̖ߍ݃p[^擾B<p>
     *
     * @return OOɏo͂ۂ̖ߍ݃p[^
     */
    public String[] getLogMessageArguments();
    
    /**
     * OOɏo͂ۂɁAÕX^bNg[XOɏo͂邩ǂݒ肷B<p>
     * ftHgł́AtrueB<br>
     *
     * @param isOutput ÕX^bNg[XOɏo͂ꍇtrue
     */
    public void setOutputStackTraceLog(boolean isOutput);
    
    /**
     * OOɏo͂ۂɁAÕX^bNg[XOɏo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAÕX^bNg[XOɏo͂
     */
    public boolean isOutputStackTraceLog();
    
    /**
     * HTTPX|X̃Xe[^Xݒ肷B<p>
     * ݒ肵Ȃꍇ́AXe[^X͕ύXȂB<br>
     *
     * @param status HTTPX|X̃Xe[^X
     */
    public void setHttpResponseStatus(int status);
    
    /**
     * HTTPX|X̃Xe[^X擾B<p>
     *
     * @return HTTPX|X̃Xe[^X
     */
    public int getHttpResponseStatus();
    
    /**
     * HTTPX|X̃Xe[^XbZ[Wݒ肷B<p>
     * HTTPX|X̃Xe[^Xݒ肳ĂȂꍇ́AB<br>
     *
     * @param message HTTPX|X̃Xe[^XbZ[W
     */
    public void setHttpResponseStatusMessage(String message);
    
    /**
     * HTTPX|X̃Xe[^XbZ[W擾B<p>
     *
     * @return HTTPX|X̃Xe[^XbZ[W
     */
    public String getHttpResponseStatusMessage();
    
    /**
     * tH[hpXݒ肷B<p>
     * ݒ肵Ȃꍇ́AtH[hȂB<br>
     *
     * @param path tH[hpX
     */
    public void setForwardPath(String path);
    
    /**
     * tH[hpX擾B<p>
     *
     * @return tH[hpX
     */
    public String getForwardPath();
    
    /**
     * Othrow邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isThrow throwꍇ́Atrue
     */
    public void setThrowException(boolean isThrow);
    
    /**
     * Othrow邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Athrow
     */
    public boolean isThrowException();
    
    /**
     * IuWFNgNGXgɐݒ肷鎞Ɏgp鑮ݒ肷B<p>
     * ftHgĺA{@link StreamExchangeInterceptorServiceMBean#DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME}B<br>
     *
     * @param name 
     * @see StreamExchangeInterceptorServiceMBean#DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME
     */
    public void setResponseObjectAttributeName(String name);
    
    /**
     * IuWFNgNGXgɐݒ肷鎞Ɏgp鑮擾B<p>
     *
     * @return 
     */
    public String getResponseObjectAttributeName();
    
    /**
     * NGXgɐݒ肷鉞IuWFNgݒ肷B<p>
     *
     * @param obj IuWFNg
     */
    public void setResponseObject(Object obj);
    
    /**
     * NGXgɐݒ肷鉞IuWFNg擾B<p>
     *
     * @return IuWFNg
     */
    public Object getResponseObject();
    
    /**
     * NGXgɐݒ肷鉞IuWFNg̃T[rXݒ肷B<p>
     *
     * @param name IuWFNg̃T[rX
     */
    public void setResponseObjectServiceName(ServiceName name);
    
    /**
     * NGXgɐݒ肷鉞IuWFNg̃T[rX擾B<p>
     *
     * @return IuWFNg̃T[rX
     */
    public ServiceName getResponseObjectServiceName();
    
    /**
     * OvpeBl擾ĉIuWFNg̃vpeBɐݒ肷}bsOݒ肷B<p>
     *
     * @param mapping O擾vpeB=IuWFNgɐݒ肷vpeB
     */
    public void setExceptionAndResponseObjectPropertyMapping(Map<String,String> mapping);
    
    /**
     * OvpeBl擾ĉIuWFNg̃vpeBɐݒ肷}bsO擾B<p>
     *
     * @return O擾vpeB=IuWFNgɐݒ肷vpeB
     */
    public Map<String,String> getExceptionAndResponseObjectPropertyMapping();
}
