/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;

/**
 * {@link TraceLoggingInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see TraceLoggingInterceptorService
 */
public interface TraceLoggingInterceptorServiceMBean extends ServiceBaseMBean{
    
    public static final String DEFAULT_TRACE_REQUEST_MESSAGE_ID  = "TLIS_00001";
    public static final String DEFAULT_TRACE_RESPONSE_MESSAGE_ID = "TLIS_00002";
    
    /**
     * g[XOo͂sǂݒ肷B<p>
     * ftHgł́AtrueB
     *
     * @param enable g[XOo͂sꍇtrue
     * @see #isEnabled()
     */
    public void setEnabled(boolean enable);
    
    /**
     * g[XOo͂sǂ𔻒肷B<p>
     *
     * @return g[XOo͂sꍇtrue
     * @see #setEnabled(boolean)
     */
    public boolean isEnabled();
    
    /**
     * Ăяoɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id o͂郍ÕbZ[WID
     */
    public void setRequestMessageId(String id);
    
    /**
     * Ăяoɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return o͂郍ÕbZ[WID
     */
    public String getRequestMessageId();
    
    /**
     * ɏo͂郍ÕbZ[WIDݒ肷B<p>
     *
     * @param id o͂郍ÕbZ[WID
     */
    public void setResponseMessageId(String id);
    
    /**
     * ɏo͂郍ÕbZ[WID擾B<p>
     *
     * @return o͂郍ÕbZ[WID
     */
    public String getResponseMessageId();
    
    /**
     * ĂяoɃOo͂邩ǂݒ肷B<p>
     * ftHǵAtrueŏo͂B<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputRequestLog(boolean isOutput);
    
    /**
     * ĂяoɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputRequestLog();
    
    /**
     * ɃOo͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputResponseLog(boolean isOutput);
    
    /**
     * ɃOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputResponseLog();
    
    /**
     * ĂяõOo͂ŌĂяoΏۂo͂邩ǂݒ肷B<p>
     * ftHǵAtrueŏo͂B<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputTarget(boolean isOutput);
    
    /**
     * ĂяõOo͂ŌĂяoΏۂo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputTarget();
    
    /**
     * ĂяõOo͂ŌĂяoΏۂvpeBw肵ďo͂悤ɐݒ肷B<p>
     *
     * @param props o͂Ώۂ̃vpeBz
     */
    public void setOutputTargetProperties(String[] props);
    
    /**
     * ĂяõOo͂ŌĂяoΏۂvpeBw肵ďo͂悤Ɏ擾B<p>
     *
     * @return o͂Ώۂ̃vpeBz
     */
    public String[] getOutputTargetProperties();
    
    /**
     * ĂяõOo͂ŌĂяo\bho͂邩ǂݒ肷B<p>
     * ftHǵAtrueŏo͂B<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputMethod(boolean isOutput);
    
    /**
     * ĂяõOo͂ŌĂяo\bho͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputMethod();
    
    /**
     * ĂяõOo͂ŌĂяo\bho͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputParameter(boolean isOutput);
    
    /**
     * ĂяõOo͂ŌĂяo\bho͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputParameter();
    
    /**
     * ĂяõOo͂ŌĂяo\bhvpeBw肵ďo͂悤ɐݒ肷B<p>
     *
     * @param props o͂郁\bh̃vpeBz
     */
    public void setOutputParameterProperties(String[] props);
    
    /**
     * ĂяõOo͂ŌĂяo\bhvpeBw肵ďo͂悤Ɏ擾B<p>
     *
     * @return o͂郁\bh̃vpeBz
     */
    public String[] getOutputParameterProperties();
    
    /**
     * ĂяõOo͂ŌĂяoX^bNo͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputCallStackTrace(boolean isOutput);
    
    /**
     * ĂяõOo͂ŌĂяo\bho͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputCallStackTrace();
    
    /**
     * ̃Oo͂Ŗ߂lo͂邩ǂݒ肷B<p>
     * ftHǵAtrueŏo͂B<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputReturn(boolean isOutput);
    
    /**
     * ̃Oo͂Ŗ߂lo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputReturn();
    
    /**
     * ̃Oo͂ŏ[ms]o͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputPerformance(boolean isOutput);
    
    /**
     * ̃Oo͂ŏ[ms]o͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputPerformance();
    
    /**
     * ̃Oo͂ŌĂяoΏۂo͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputTargetOnResponse(boolean isOutput);
    
    /**
     * ̃Oo͂ŌĂяoΏۂo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputTargetOnResponse();
    
    /**
     * ̃Oo͂ŌĂяo\bho͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputMethodOnResponse(boolean isOutput);
    
    /**
     * ̃Oo͂ŌĂяo\bho͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputMethodOnResponse();
    
    /**
     * ̃Oo͂ŌĂяo\bho͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputParameterOnResponse(boolean isOutput);
    
    /**
     * ̃Oo͂ŌĂяo\bho͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputParameterOnResponse();
    
    /**
     * ĂяõOo͂Ŗ߂lvpeBw肵ďo͂悤ɐݒ肷B<p>
     *
     * @param props o͂߂l̃vpeBz
     */
    public void setOutputReturnProperties(String[] props);
    
    /**
     * ĂяõOo͂Ŗ߂lvpeBw肵ďo͂悤Ɏ擾B<p>
     *
     * @return o͂߂l̃vpeBz
     */
    public String[] getOutputReturnProperties();
    
    /**
     * ̃Oo͂ŔOo͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputThrowable(boolean isOutput);
    
    /**
     * ̃Oo͂ŔOo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAo͂
     */
    public boolean  isOutputThrowable();
}