/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.List;

/**
 * uCN|CgB<p>
 *
 * @author M.Takata
 */
public interface BreakPoint{
    
    /**
     * uCN|Cg̗L/ݒ肷B<p>
     *
     * @param enabled Lɂꍇ́Atrue
     */
    public void setEnabled(boolean enabled);
    
    /**
     * uCN|Cg̗L/𔻒肷B<p>
     *
     * @return truȅꍇAL
     */
    public boolean isEnabled();
    
    /**
     * uCN|Cgőҋ@ĂXbhĊJB<p>
     */
    public void resume();
    
    /**
     * uCN|Cgőҋ@ĂXbhSčĊJB<p>
     */
    public void resumeAll();
    
    /**
     * uCN|Cgőҋ@ĂXbh擾B<p>
     *
     * @return uCN|Cgőҋ@ĂXbh̃Xg
     */
    public List<String> suspendThreads();
    
    /**
     * uCN|CgɃXbhĂ܂őҋ@B<p>
     */
    public void waitSuspend() throws InterruptedException;
    
    /**
     * uCN|CgɃXbhĂ܂őҋ@B<p>
     *
     * @param timeout ҋ@ő厞[ms]
     * @return ^CAEgꍇ́Afalse
     */
    public boolean waitSuspend(long timeout) throws InterruptedException;
    
    /**
     * uCN|CgɎw肳ꂽXbhĂ܂őҋ@B<p>
     *
     * @param threadName Xbh
     */
    public void waitSuspend(String threadName) throws InterruptedException;
    
    /**
     * uCN|CgɎw肳ꂽXbhĂ܂őҋ@B<p>
     *
     * @param threadName Xbh
     * @param timeout ҋ@ő厞[ms]
     * @return ^CAEgꍇ́Afalse
     */
    public boolean waitSuspend(String threadName, long timeout) throws InterruptedException;
}