/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.io;

import java.io.*;

/**
 * vtBNXt@CtB^B<p>
 * w肳ꂽvtBNX̃t@Ĉ݂𒊏otB^B
 *
 * @author H.Nakano
 */
public class PrefixFileFilter implements FilenameFilter, Serializable{
    
    private static final long serialVersionUID = 3579204076741445814L;
    
    /**
     * t@C̃vtBNXB<p>
     */
    protected String prefix;
    
    private String upperPrefix;
    
    /**
     * vtBNX̑啶Eʂ邩ǂ̃tOB<p>
     * ftHǵAfalseŁA啶EʂB<br>
     */
    protected boolean isIgnoreCase;
    
    /**
     * vtBNXw肵ȂtB^̃CX^X𐶐B<p>
     */
    public PrefixFileFilter(){
        this(null, false);
    }
    
    /**
     * w肵vtBNX̃t@Ĉ݂𒊏otB^̃CX^X𐶐B<p>
     *
     * @param prefix vtBNX
     */
    public PrefixFileFilter(String prefix){
        this(prefix, false);
    }
    
    /**
     * w肵vtBNX̃t@Ĉ݂𒊏otB^̃CX^X𐶐B<p>
     *
     * @param prefix vtBNX
     * @param isIgnoreCase vtBNX̑啶EʂȂꍇtrue
     */
    public PrefixFileFilter(
        String prefix,
        boolean isIgnoreCase
    ){
        setPrefix(prefix);
        setIgnoreCase(isIgnoreCase);
    }
    
    /**
     * t@C̃vtBNXݒ肷B<p>
     * null󕶎w肵ꍇ́AtB^OȂB<br>
     * 
     * @param prefix t@C̃vtBNX
     */
    public void setPrefix(String prefix){
        if(prefix == null || prefix.length() == 0){
            this.prefix = null;
        }else{
            this.prefix = prefix;
            upperPrefix = prefix.toUpperCase();
        }
    }
    
    /**
     * t@C̃vtBNX擾B<p>
     * 
     * @return t@C̃vtBNX
     */
    public String getPrefix(){
        return prefix;
    }
    
    /**
     * vtBNX̑啶E𖳎邩ǂݒ肷B<p>
     * ftHǵAtrueB
     *
     * @param isIgnoreCase 啶EʂȂꍇtrue
     */
    public void setIgnoreCase(boolean isIgnoreCase){
        this.isIgnoreCase = isIgnoreCase;
    }
    
    /**
     * vtBNX̑啶E𖳎邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA啶EʂȂ
     */
    public boolean isIgnoreCase(){
        return isIgnoreCase;
    }
    
    /**
     * w肳ꂽvtBNX̃t@Cǂ肷B<p>
     * 
     * @param dir fBNg
     * @param fileName t@C
     * @return w肳ꂽvtBNX̃t@C̏ꍇtrue
     */
    @Override
    public boolean accept(File dir, String fileName) {
        if(isIgnoreCase){
            final String tmp = fileName.toUpperCase();
            return tmp.startsWith(upperPrefix);
        }else{
            return fileName.startsWith(prefix);
        }
    }
}
