/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.util.*;

/**
 * t@NgT[rXNXB<p>
 *
 * @author M.Takata
 */
public abstract class FactoryServiceBase<T> extends ServiceBase
 implements FactoryServiceBaseMBean<T>{
    
    private static final long serialVersionUID = -7723361215992951033L;

    /**
     * ̃t@NgɂĐꂽIuWFNgǗ邩ǂtOB<p>
     * ǗꍇAtrueB<br>
     */
    protected volatile boolean isManaged;
    
    /**
     * ̃t@NgɂăXbhPʂɃIuWFNg𐶐邩ǂtOB<p>
     * XbhPʂɐꍇAtrueB<br>
     */
    protected volatile boolean isThreadLocal;
    
    /**
     * ǗĂCX^XێWB<p>
     */
    protected Set<T> managedInstances = Collections.<T>synchronizedSet(new HashSet<T>());
    
    /**
     * XbhPʂɊǗĂCX^XێThreadLocalB<p>
     */
    protected ThreadLocal<T> threadLocal = new ThreadLocal<T>();
    
    /**
     * T[rX̊JnɁAt@NgIuWFNg݂̐Ă݂邩ǂ̃tOB<p>
     * ftHgł́AtrueB<br>
     */
    protected boolean isCreateTemplateOnStart = true;
    
    /**
     * RXgN^B<p>
     */
    public FactoryServiceBase(){
        super();
    }
    
    // FactoryServiceJavaDoc
    @Override
    public void setManagement(boolean isManaged){
        this.isManaged = isManaged;
    }
    
    // FactoryServiceJavaDoc
    @Override
    public boolean isManagement(){
        return isManaged;
    }
    
    // FactoryServiceJavaDoc
    @Override
    public void setThreadLocal(boolean isThreadLocal){
        this.isThreadLocal = isThreadLocal;
    }
    
    // FactoryServiceJavaDoc
    @Override
    public boolean isThreadLocal(){
        return isThreadLocal;
    }
    
    // FactoryServiceJavaDoc
    @Override
    public void release(Object service){
        if(managedInstances.size() != 0){
            managedInstances.remove(service);
        }
        threadLocal.set(null);
    }
    
    // FactoryServiceJavaDoc
    @Override
    public void release(){
        final Object[] instances = managedInstances.toArray();
        for(Object instance : instances){
            release(instance);
        }
        threadLocal = new InheritableThreadLocal<T>();
    }
    
    // FactoryServiceJavaDoc
    @Override
    public T newInstance(){
        T obj = null;
        if(isManaged){
            synchronized(managedInstances){
                if(isThreadLocal){
                    obj = threadLocal.get();
                }
                if(obj == null){
                    try{
                        obj = createInstance();
                    }catch(Exception e){
                        return null;
                    }
                    if(isThreadLocal){
                        threadLocal.set(obj);
                    }
                }
                managedInstances.add(obj);
            }
        }else{
            if(isThreadLocal){
                obj = threadLocal.get();
            }
            if(obj == null){
                try{
                    obj = createInstance();
                }catch(Exception e){
                    return null;
                }
                if(isThreadLocal){
                    threadLocal.set(obj);
                }
            }
        }
        return obj;
    }
    
    // FactoryServiceBaseMBeanJavaDoc
    @Override
    public void setCreateTemplateOnStart(boolean isCreate){
        isCreateTemplateOnStart = isCreate;
    }
    
    // FactoryServiceBaseMBeanJavaDoc
    @Override
    public boolean isCreateTemplateOnStart(){
        return isCreateTemplateOnStart;
    }
    
    /**
     * ̃t@NgŐCX^X̓AǗĂCX^X̏W擾B<p>
     *
     * @return ǗĂCX^X̏W
     */
    protected Set<T> getManagedInstanceSet(){
        return managedInstances;
    }
    
    /**
     * ̃t@Ng񋟂IuWFNg̃CX^X𐶐B<p>
     *
     * @return ̃t@Ng񋟂IuWFNg̃CX^X
     * @exception Exception ɗOꍇ
     */
    protected abstract T createInstance() throws Exception;
    
    /**
     * ̃t@Ng񋟂IuWFNg̃CX^Xev[gpɐB<p>
     *
     * @return ̃t@Ng񋟂IuWFNg̃CX^X
     * @exception Exception ɗOꍇ
     */
    protected T createTemplate() throws Exception{
        return createInstance();
    }
    
    /**
     * ̃t@Ng̐㏈sB<p>
     * {@link #createInstance()}ĂяoāÃt@NgCX^X̐\ǂeXgB<br>
     * 
     * @exception Exception createInstance()Ɏsꍇ
     */
    @Override
    protected void postStartService() throws Exception{
        super.postStartService();
        if(isCreateTemplateOnStart){
            final T obj = createTemplate();
            release(obj);
        }
    }
    
    /**
     * ̃t@Ng̔j㏈sB<p>
     * ǗĂCX^XNAB<br>
     * 
     * @exception Exception j㏈Ɏsꍇ
     */
    @Override
    protected void postDestroyService() throws Exception{
        super.postDestroyService();
        managedInstances.clear();
    }
}
