/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.beans.*;
import java.net.*;
import java.io.*;
import java.util.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

import jp.ossc.nimbus.beans.*;
import jp.ossc.nimbus.service.log.*;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.repository.Repository;
import jp.ossc.nimbus.util.*;

/**
 * T[rX[_B<p>
 * T[rX`ǂݍ݁AT[rXo^郍[_łB<br>
 * T[rX[_́AT[rX{@link Service}ƂĎAT[rX̐ANƋɁAT[rXՂNAɔzueT[rXzXeBOB<br>
 * 
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class DefaultServiceLoaderService extends ServiceBase
 implements ServiceLoader, DefaultServiceLoaderServiceMBean{
    
    private static final long serialVersionUID = 7335188900913701079L;
    
    // bZ[WID`
    private static final String SVCL_ = "SVCL_";
    private static final String SVCL_0 = SVCL_ + 0;
    private static final String SVCL_00 = SVCL_0 + 0;
    private static final String SVCL_000 = SVCL_00 + 0;
    private static final String SVCL_0000 = SVCL_000 + 0;
    private static final String SVCL_00001 = SVCL_0000 + 1;
    private static final String SVCL_00002 = SVCL_0000 + 2;
    private static final String SVCL_00003 = SVCL_0000 + 3;
    private static final String SVCL_00004 = SVCL_0000 + 4;
    private static final String SVCL_00005 = SVCL_0000 + 5;
    private static final String SVCL_00006 = SVCL_0000 + 6;
    private static final String SVCL_00007 = SVCL_0000 + 7;
    private static final String SVCL_00008 = SVCL_0000 + 8;
    private static final String SVCL_00009 = SVCL_0000 + 9;
    private static final String SVCL_00010 = SVCL_000 + 10;
    private static final String SVCL_00011 = SVCL_000 + 11;
    private static final String SVCL_00012 = SVCL_000 + 12;
    private static final String SVCL_00013 = SVCL_000 + 13;
    private static final String SVCL_00014 = SVCL_000 + 14;
    private static final String SVCL_00015 = SVCL_000 + 15;
    private static final String SVCL_00016 = SVCL_000 + 16;
    private static final String SVCL_00017 = SVCL_000 + 17;
    private static final String SVCL_00018 = SVCL_000 + 18;
    private static final String SVCL_00019 = SVCL_000 + 19;
    private static final String SVCL_00020 = SVCL_000 + 20;
    private static final String SVCL_00024 = SVCL_000 + 24;
    private static final String SVCL_00025 = SVCL_000 + 25;
    private static final String SVCL_00026 = SVCL_000 + 26;
    private static final String SVCL_00028 = SVCL_000 + 28;
    private static final String SVCL_00030 = SVCL_000 + 30;
    private static final String SVCL_00031 = SVCL_000 + 31;
    private static final String SVCL_00032 = SVCL_000 + 32;
    private static final String SVCL_00033 = SVCL_000 + 33;
    
    public static final String PROPERTY_DOCUMENT_BUILDER_FACTORY_CLASSNAME = DefaultServiceLoaderService.class.getName() + ".documentBuilderFactoryClassName";
    
    /**
     * ftHg̃T[rXB<p>
     * {@link #setServiceName(String)}Ȃꍇ́ÃftHǧɁA"{T[rX`URL}"tT[rXƂȂB<br>
     *
     * @see #setServiceName(String)
     */
    protected static final String DEFAULT_NAME
     = DefaultServiceLoaderService.class.getName();
    
    /**
     * ftHg{@link ServiceManager}C^tF[XNXB<p>
     * 
     * @see #setServiceManagerClassName(String)
     */
    private static final String DEFAULT_SERVICE_MANAGER_CLASS_NAME
     = jp.ossc.nimbus.core.DefaultServiceManagerService.class.getName();
    
    /**
     * VMɓo^Vbg_EtbÑ}bsOB<p>
     * &lt;manager&gt;vfshutdown-hooktrueݒ肳ĂꍇA{@link Runtime#addShutdownHook(Thread)}ŁAServiceManagerɒ~AjsXbho^B<br>
     * VMN܂܂ŁAServiceManagerjꍇȂǂ́Ao^XbhsvɂȂ邽߁Ao^XbhstaticɊǗĂB<br>
     */
    protected static final Map<String, Thread> shutdownHooks = new HashMap<String, Thread>();
    
    /**
     * ̃[_[hT[rX`t@CURLB<p>
     *
     * @see #setServiceURL(URL)
     * @see #getServiceURL()
     */
    protected URL serviceURL;
    
    /**
     * ̃[_Ń[hT[rX`̃[g^f[^B<p>
     *
     * @see #getServerMetaData()
     */
    protected NimbusMetaData serverData;
    
    /**
     * &lt;manager&gt;vfŒ`ꂽServiceManager̖OƁAServiceManageri[}bvB<p>
     * 
     * @see #getServiceManagers()
     */
    protected Map<String, ServiceManager> managerMap;
    
    /**
     * &lt;property-editors&gt;vfŐݒ肳ꂽjava.beans.PropertyEditorێ}bvB<p>
     */
    protected ClassMappingTree<Class<PropertyEditor>> propertyEditors;
    
    /**
     * T[rX`XMLDTDŕ]邩ǂtOB<p>
     * ]ꍇtrueB<br>
     */
    protected boolean isValidate;
    
    /**
     * ܂łɃ[hT[rXSĐɊJnłĂ邩`FbN邩ǂtOB<p>
     * `FbNꍇtrueB
     */
    protected boolean isCheckLoadManagerCompleted;
    
    /**
     * T[rXSĐɊJnłĂ邩`FbN}l[W̏WB<p>
     */
    protected Set<String> checkLoadManagerNames;
    
    /**
     * T[rX[h\B<p>
     */
    protected ServiceLoaderConfig loaderConfig;
    
    /**
     * [hOdefault-logvf̏B<p>
     */
    protected DefaultLogMetaData preDefaultLogData;
    
    /**
     * ServiceManagerC^tF[X̎NXB<p>
     * ftHǵADEFAULT_SERVICE_MANAGER_CLASS_NAMEB<br>
     *
     * @see #setServiceManagerClassName(String)
     * @see #getServiceManagerClassName()
     */
    protected String serviceManagerClassName = DEFAULT_SERVICE_MANAGER_CLASS_NAME;
    
    protected String documentBuilderFactoryClassName;
    
    // DefaultServiceLoaderServiceMBeanJavaDoc
    @Override
    public void setCheckLoadManagerCompleted(boolean isCheck){
        isCheckLoadManagerCompleted = isCheck;
    }
    
    // DefaultServiceLoaderServiceMBeanJavaDoc
    @Override
    public boolean isCheckLoadManagerCompleted(){
        return isCheckLoadManagerCompleted;
    }
    
    // DefaultServiceLoaderServiceMBeanJavaDoc
    @Override
    public void setCheckLoadManagerCompletedBy(String[] managerNames){
        if(managerNames != null && managerNames.length != 0){
            checkLoadManagerNames = new HashSet<String>();
            for(int i = 0; i < managerNames.length; i++){
                checkLoadManagerNames.add(managerNames[i]);
            }
        }else{
            checkLoadManagerNames = null;
        }
    }
    
    // DefaultServiceLoaderServiceMBeanJavaDoc
    @Override
    public String[] getCheckLoadManagerCompletedBy(){
        return checkLoadManagerNames == null
             ? new String[0] : checkLoadManagerNames
                .toArray(new String[checkLoadManagerNames.size()]);
    }
    
    @Override
    public void setDocumentBuilderFactoryClassName(String name){
        documentBuilderFactoryClassName = name;
    }
    @Override
    public String getDocumentBuilderFactoryClassName(){
        return documentBuilderFactoryClassName;
    }
    
    /**
     * RXgN^B<p>
     */
    public DefaultServiceLoaderService(){
        super();
        setServiceName(DEFAULT_NAME);
    }
    
    /**
     * [_̏sB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>{@link ServiceManagerFactory}֎go^B</li>
     *   <li>CX^Xϐ𐶐B</li>
     * </ol>
     */
    @Override
    public void createService(){
        final Logger logger = getLogger();
        
        if(serverData == null && serviceURL == null){
            serviceURL = Utility.getDefaultServiceURL();
            logger.write(SVCL_00009, serviceURL);
        }
        
        if(serviceURL != null){
            final String myName = getServiceName();
            setServiceName(
                myName == null ? (DEFAULT_NAME + '{' + serviceURL + '}') : myName
            );
        }
        
        if(serviceURL != null){
            ServiceManagerFactory.registerLoader(this);
        }
        
        managerMap = new LinkedHashMap<String, ServiceManager>();
        propertyEditors = new ClassMappingTree<Class<PropertyEditor>>();
    }
    
    /**
     * [_̊JnsB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>{@link #loadServerMetaData()}ĂяoB</li>
     *   <li>CX^XϐB</li>
     *   <li>{@link #deployServerMetaData(NimbusMetaData)}ĂяoB</li>
     *   <li>&lt;manager&gt;vfŒ`ꂽ{@link ServiceManager}NB</li>
     * </ol>
     * @exception Exception T[rX`̓ǂݍ݁AzuɎsꍇB܂́AServiceManager̐AJnɎsꍇ
     */
    @Override
    public void startService() throws Exception{
        final Logger logger = getLogger();
        
        try{
            loadServerMetaData();
        }catch(Exception e){
            logger.write(SVCL_00010, e, serviceURL);
            throw e;
        }
        
        managerMap.clear();
        propertyEditors.clear();
        
        try{
            deployServerMetaData(serverData);
        }catch(Exception e){
            logger.write(SVCL_00024, e, serviceURL);
            throw e;
        }
        
        for(ServiceManager manager : managerMap.values()){
            try{
                startupServiceManager(manager);
            }catch(Exception e){
                logger.write(SVCL_00025, e, manager.getServiceName());
                manager.destroy();
            }
        }
        if(isCheckLoadManagerCompleted){
            if(checkLoadManagerNames == null){
                ServiceManagerFactory.checkLoadManagerCompleted();
            }else{
                ServiceManagerFactory.checkLoadManagerCompletedBy(
                    checkLoadManagerNames
                );
            }
        }
    }
    
    /**
     * [_̒~sB<p>
     * <ol>
     *   <li>&lt;manager&gt;vfŒ`ꂽ{@link ServiceManager}~B</li>
     *   <li>&lt;manager&gt;vfshutdown-hookŒ`ꂽlɏ]āA{@link Runtime#removeShutdownHook(Thread)}sB</li>
     *   <li>&lt;manager&gt;vfŒ`ꂽ{@link ServiceManager}jB</li>
     *   <li>CX^XϐB</li>
     * </ol>
     *
     * @exception Exception ServiceManager̒~Ɏsꍇ
     */
    @Override
    public void stopService() throws Exception{
        
        undeployServerMetaData(serverData);
        
        managerMap.clear();
        propertyEditors.clear();
    }
    
    /**
     * [_̔jsB<p>
     * <ol>
     *   <li>CX^XϐjB</li>
     *   <li>{@link ServiceManagerFactory}玩g폜B</li>
     * </ol>
     *
     * @exception Exception ServiceManager̔jɎsꍇ
     */
    @Override
    public void destroyService() throws Exception{
        
        managerMap = null;
        propertyEditors = null;
        
        ServiceManagerFactory.unregisterLoader(this);
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public NimbusMetaData getServerMetaData(){
        return serverData;
    }
    
    /**
     * &lt;nimbus&gt;vf̃^f[^ݒ肷B<p>
     *
     * @param data T[rX`&lt;nimbus&gt;vf^f[^
     */
    public void setServerMetaData(NimbusMetaData data){
        serverData = data;
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public void setServiceURL(URL url) throws IllegalArgumentException{
        final Logger logger = getLogger();
        try{
            url.openConnection();
        }catch(IOException e){
            final MessageRecordFactory message = getMessageRecordFactory();
            throw new IllegalArgumentException(
                message.findMessage(SVCL_00004, url)
            );
        }
        serviceURL = url;
        logger.write(SVCL_00005, serviceURL);
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public URL getServiceURL(){
        return serviceURL;
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public Set<ServiceManager> getServiceManagers(){
        return new HashSet<ServiceManager>(managerMap.values());
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public PropertyEditor findEditor(Class<?> type){
        final Logger logger = getLogger();
        if(type == null){
            return null;
        }
        PropertyEditor editor = null;
        Class<PropertyEditor> clazz = propertyEditors.getValue(type);
        if(clazz == null){
            editor = NimbusPropertyEditorManager.findEditor(type);
        }else{
            try{
                editor = clazz.newInstance();
            }catch(InstantiationException e){
                logger.write(SVCL_00028, e, type, clazz);
                return null;
            }catch(IllegalAccessException e){
                logger.write(SVCL_00028, e, type, clazz);
                return null;
            }
        }
        return editor;
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public void setServicePath(String path) throws IllegalArgumentException{
        final Logger logger = getLogger();
        final URL url = Utility.convertServicePathToURL(path);
        try{
            setServiceURL(url);
            logger.write(SVCL_00006, url);
        }catch(IllegalArgumentException e){
            final MessageRecordFactory message = getMessageRecordFactory();
            throw new IllegalArgumentException(
                message.findMessage(SVCL_00007, path)
            );
        }
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public void setValidate(boolean validate){
        isValidate = validate;
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public boolean isValidate(){
        return isValidate;
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public void setConfig(ServiceLoaderConfig config){
        loaderConfig = config;
        if(loaderConfig != null){
            String prop = loaderConfig.getProperty(PROPERTY_DOCUMENT_BUILDER_FACTORY_CLASSNAME);
            if(prop != null){
                documentBuilderFactoryClassName = prop;
            }
        }
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public ServiceLoaderConfig getConfig(){
        return loaderConfig;
    }
    
    // ServiceLoaderJavaDoc
    @SuppressWarnings("unchecked")
    @Override
    public void setServiceManagerClassName(String className)
     throws ClassNotFoundException, IllegalArgumentException{
        final Logger logger = getLogger();
        if(className != null && className.length() != 0){
            Class<ServiceManager> clazz = null;
            try{
                clazz = (Class<ServiceManager>)Class.forName(
                    className,
                    true,
                    NimbusClassLoader.getInstance()
                );
            }catch(ClassNotFoundException e){
                logger.write(
                    SVCL_00001,
                    e,
                    ServiceManager.class, className
                );
                throw e;
            }
            if(ServiceManager.class.isAssignableFrom(clazz)){
                serviceManagerClassName = className;
                logger.write(SVCL_00002, className);
            }else{
                final MessageRecordFactory message = getMessageRecordFactory();
                throw new IllegalArgumentException(
                    message.findMessage(SVCL_00003, className)
                );
            }
        }
    }
    
    // ServiceLoaderJavaDoc
    @Override
    public String getServiceManagerClassName(){
        return serviceManagerClassName;
    }
    
    /**
     * T[rX`ǂݍ݁AT[rX`&lt;nimbus&gt;vf^f[^\zB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>{@link #setServiceURL(URL)}Őݒ肳ꂽURLT[rX`XMLǂݍ݁Ap[XB</li>
     *   <li>p[XT[rX`XMLA{@link NimbusMetaData}𐶐BServerMetaData̐̉ߒŁAevfɑΉ郁^f[^B</li>
     * </ol>
     *
     * @exception ParserConfigurationException XMLp[T̐Ɏsꍇ
     * @exception IOException {@link #setServiceURL(URL)}Őݒ肳ꂽURLɃT[rX`XMLȂꍇ
     * @exception SAXException T[rX`XML̃p[XɎsꍇ
     * @exception DeploymentException T[rX`̐ݒɌ肪ꍇ
     */
    public void loadServerMetaData()
     throws IOException, ParserConfigurationException, SAXException,
            DeploymentException{
        final Logger logger = getLogger();
        
        logger.write(SVCL_00008);
        
        if(serverData != null && serviceURL == null){
            return;
        }
        
        if(serviceURL == null){
            serviceURL = Utility.getDefaultServiceURL();
            logger.write(SVCL_00009, serviceURL);
        }
        serverData = loadServerMetaData(serviceURL.openStream());
    }
    
    /**
     * T[rX`ǂݍ݁AT[rX`&lt;nimbus&gt;vf^f[^\zB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>w肳ꂽURLT[rX`XMLǂݍ݁Ap[XB</li>
     *   <li>p[XT[rX`XMLA{@link NimbusMetaData}𐶐BServerMetaData̐̉ߒŁAevfɑΉ郁^f[^B</li>
     * </ol>
     *
     * @param url T[rX`URL
     * @exception ParserConfigurationException XMLp[T̐Ɏsꍇ
     * @exception IOException {@link #setServiceURL(URL)}Őݒ肳ꂽURLɃT[rX`XMLȂꍇ
     * @exception SAXException T[rX`XML̃p[XɎsꍇ
     * @exception DeploymentException T[rX`̐ݒɌ肪ꍇ
     */
    protected NimbusMetaData loadServerMetaData(URL url)
     throws IOException, ParserConfigurationException, SAXException,
            DeploymentException{
        
        if(url == null){
            return null;
        }
        return loadServerMetaData(url.openStream());
    }
    
    /**
     * T[rX`ǂݍ݁AT[rX`&lt;nimbus&gt;vf^f[^\zB<p>
     * ł́Aȉ̏sB<br>
     * <ol>
     *   <li>w肳ꂽXg[T[rX`XMLǂݍ݁Ap[XB</li>
     *   <li>p[XT[rX`XMLA{@link NimbusMetaData}𐶐BServerMetaData̐̉ߒŁAevfɑΉ郁^f[^B</li>
     * </ol>
     *
     * @param is T[rX`̓Xg[
     * @exception ParserConfigurationException XMLp[T̐Ɏsꍇ
     * @exception IOException {@link #setServiceURL(URL)}Őݒ肳ꂽURLɃT[rX`XMLȂꍇ
     * @exception SAXException T[rX`XML̃p[XɎsꍇ
     * @exception DeploymentException T[rX`̐ݒɌ肪ꍇ
     */
    public NimbusMetaData loadServerMetaData(InputStream is)
     throws IOException, ParserConfigurationException, SAXException,
            DeploymentException{
        final InputSource inputSource = new InputSource(is);
        DocumentBuilderFactory domFactory = null;
        String className = System.getProperty(PROPERTY_DOCUMENT_BUILDER_FACTORY_CLASSNAME);
        if(className == null){
            className = documentBuilderFactoryClassName;
        }
        if(className == null){
            domFactory = DocumentBuilderFactory.newInstance();
        }else{
            domFactory = DocumentBuilderFactory.newInstance(
                className,
                NimbusClassLoader.getInstance()
            );
        }
        domFactory.setValidating(isValidate());
        final DocumentBuilder builder = domFactory.newDocumentBuilder();
        final NimbusEntityResolver resolver = new NimbusEntityResolver();
        builder.setEntityResolver(resolver);
        final MyErrorHandler handler = new MyErrorHandler();
        builder.setErrorHandler(handler);
        final Document doc = builder.parse(inputSource);
        if(handler.isError()){
            final MessageRecordFactory message = getMessageRecordFactory();
            throw new DeploymentException(
                message.findMessage(SVCL_00033, serviceURL)
            );
        }
        
        final NimbusMetaData serverData = new NimbusMetaData(this, serviceURL);
        final DocumentType docType = doc.getDoctype();
        if(docType != null){
            serverData.setDocType(
                "<!DOCTYPE " + docType.getName() + " PUBLIC \""
                     + docType.getPublicId() + "\" \""
                     + docType.getSystemId() + "\">"
            );
        }
        if(inputSource.getEncoding() != null){
            serverData.setEncoding(inputSource.getEncoding());
        }
        serverData.importXML(doc.getDocumentElement());
        
        final Map<String, String> props = serverData.getProperties();
        final Object[] propKeys = props.keySet().toArray();
        for(int i = 0; i < propKeys.length; i++){
            final String propKey = (String)propKeys[i];
            String prop = props.get(propKey);
            // VXevpeB̒u
            prop = Utility.replaceSystemProperty(prop, false);
            // T[rX[_\vpeB̒u
            prop = Utility.replaceServiceLoderConfig(
                getConfig(),
                prop,
                false
            );
            // T[ovpeB̒u
            prop = Utility.replaceServerProperty(prop, true);
            ServiceManagerFactory.setProperty(propKey, prop);
        }
        return serverData;
    }
    
    /**
     * T[rX`&lt;nimbus&gt;vf^f[^zuB<p>
     *
     * @param serverData T[rX`&lt;nimbus&gt;vf^f[^
     * @exception ParserConfigurationException XMLp[T̐Ɏsꍇ
     * @exception IOException &lt;ref-url&gt;vfŎw肳ꂽURL̃T[rX`XMLȂꍇ
     * @exception SAXException T[rX`XML̃p[XɎsꍇ
     * @exception DeploymentException T[rX`̐ݒɌ肪ꍇ
     */
    protected void deployServerMetaData(NimbusMetaData serverData)
     throws IOException, ParserConfigurationException, SAXException,
            DeploymentException{
        final Logger logger = getLogger();
        
        logger.write(SVCL_00011, serverData);
        
        final DefaultLogMetaData defaultLogData
             = serverData.getDefaultLog();
        deployDefaultLogMetaData(defaultLogData);
        
        deployPropertyEditors();
        
        // T[oLogger̐ݒ
        final ServiceNameMetaData logData = serverData.getLog();
        if(logData != null){
            final String managerName = logData.getManagerName();
            final String logName = logData.getServiceName();
            if(managerName != null && logName != null){
                ServiceManagerFactory.setLogger(managerName, logName);
            }
        }
        
        // T[oMessageRecordFactory̐ݒ
        final ServiceNameMetaData messageData = serverData.getMessage();
        if(messageData != null){
            final String managerName = messageData.getManagerName();
            final String messageName = messageData.getServiceName();
            if(managerName != null && messageName != null){
                ServiceManagerFactory.setMessageRecordFactory(
                    managerName,
                    messageName
                );
            }
        }
        
        // T[oRepository̐ݒ
        final ServiceNameMetaData repositoryData = serverData.getRepository();
        if(repositoryData != null){
            final String managerName = repositoryData.getManagerName();
            final String repositoryName = repositoryData.getServiceName();
            if(managerName != null && repositoryName != null){
                ServiceManagerFactory.setManagerRepository(
                    managerName,
                    repositoryName
                );
            }
        }
        
        for(ManagerMetaData managerData : serverData.getManagers()){
            deployManagerMetaData(managerData);
        }
    }
    
    /**
     * T[rX`&lt;nimbus&gt;vf^f[^폜B<p>
     *
     * @param serverData T[rX`&lt;nimbus&gt;vf^f[^
     * @exception DeploymentException T[rX`̐ݒɌ肪ꍇ
     */
    protected void undeployServerMetaData(NimbusMetaData serverData)
     throws DeploymentException{
        
        for(ServiceManager manager : managerMap.values()){
            shutdownServiceManager(manager);
        }
        
        // T[oRepository̐ݒ
        final ServiceNameMetaData repositoryData = serverData.getRepository();
        if(repositoryData != null){
            final String managerName = repositoryData.getManagerName();
            final String repositoryName = repositoryData.getServiceName();
            if(managerName != null && repositoryName != null){
                if(ServiceManagerFactory
                    .isRegisteredService(managerName, repositoryName)){
                    ServiceManagerFactory.setManagerRepository(
                        (Repository)null
                    );
                }
            }
        }
        
        final DefaultLogMetaData defaultLogData
             = serverData.getDefaultLog();
        undeployDefaultLogMetaData(defaultLogData);
    }
    
    /**
     * T[oLogger̐ݒsB<p>
     *
     * @param defaultLogData T[rX`&lt;default-log&gt;vf^f[^
     */
    protected void deployDefaultLogMetaData(DefaultLogMetaData defaultLogData){
        if(defaultLogData == null){
            return;
        }
        
        preDefaultLogData = new DefaultLogMetaData(defaultLogData.getParent());
        
        final Logger logger = getLogger();
        DefaultLogMetaData.LogCategoryMetaData categoryData
             = defaultLogData.getDebug();
        if(categoryData != null){
            final DefaultLogMetaData.LogCategoryMetaData preDebugData
                 = new DefaultLogMetaData.LogCategoryMetaData(preDefaultLogData);
            preDebugData.setOutput(
                ServiceManagerFactory.DEFAULT_LOGGER.isSystemDebugEnabled()
            );
            ServiceManagerFactory.DEFAULT_LOGGER
                .setSystemDebugEnabled(categoryData.isOutput());
            preDefaultLogData.setDebug(preDebugData);
            if(ServiceManagerFactory.DEFAULT_LOGGER.isSystemDebugEnabled()){
                logger.write(SVCL_00012, DefaultLoggerService.SYSTEM_DEBUG_CATEGORY_LABEL);
            }else{
                logger.write(SVCL_00013, DefaultLoggerService.SYSTEM_DEBUG_CATEGORY_LABEL);
            }
        }else{
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(false);
        }
        categoryData = defaultLogData.getInformation();
        if(categoryData != null){
            final DefaultLogMetaData.LogCategoryMetaData preInfoData
                 = new DefaultLogMetaData.LogCategoryMetaData(preDefaultLogData);
            preInfoData.setOutput(
                ServiceManagerFactory.DEFAULT_LOGGER.isSystemInfoEnabled()
            );
            ServiceManagerFactory.DEFAULT_LOGGER
                .setSystemInfoEnabled(categoryData.isOutput());
            preDefaultLogData.setInformation(preInfoData);
            if(ServiceManagerFactory.DEFAULT_LOGGER.isSystemInfoEnabled()){
                logger.write(SVCL_00012, DefaultLoggerService.SYSTEM_INFO_CATEGORY_LABEL);
            }else{
                logger.write(SVCL_00013, DefaultLoggerService.SYSTEM_INFO_CATEGORY_LABEL);
            }
        }else{
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(true);
        }
        categoryData = defaultLogData.getWarning();
        if(categoryData != null){
            final DefaultLogMetaData.LogCategoryMetaData preWarnData
                 = new DefaultLogMetaData.LogCategoryMetaData(preDefaultLogData);
            preWarnData.setOutput(
                ServiceManagerFactory.DEFAULT_LOGGER.isSystemWarnEnabled()
            );
            ServiceManagerFactory.DEFAULT_LOGGER
                .setSystemWarnEnabled(categoryData.isOutput());
            preDefaultLogData.setWarning(preWarnData);
            if(ServiceManagerFactory.DEFAULT_LOGGER.isSystemWarnEnabled()){
                logger.write(SVCL_00012, DefaultLoggerService.SYSTEM_WARN_CATEGORY_LABEL);
            }else{
                logger.write(SVCL_00013, DefaultLoggerService.SYSTEM_WARN_CATEGORY_LABEL);
            }
        }else{
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(true);
        }
        categoryData = defaultLogData.getError();
        if(categoryData != null){
            final DefaultLogMetaData.LogCategoryMetaData preErrorData
                 = new DefaultLogMetaData.LogCategoryMetaData(preDefaultLogData);
            preErrorData.setOutput(
                ServiceManagerFactory.DEFAULT_LOGGER.isSystemErrorEnabled()
            );
            ServiceManagerFactory.DEFAULT_LOGGER
                .setSystemErrorEnabled(categoryData.isOutput());
            preDefaultLogData.setError(preErrorData);
            if(ServiceManagerFactory.DEFAULT_LOGGER.isSystemErrorEnabled()){
                logger.write(SVCL_00012, DefaultLoggerService.SYSTEM_ERROR_CATEGORY_LABEL);
            }else{
                logger.write(SVCL_00013, DefaultLoggerService.SYSTEM_ERROR_CATEGORY_LABEL);
            }
        }else{
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(true);
        }
        categoryData = defaultLogData.getFatal();
        if(categoryData != null){
            final DefaultLogMetaData.LogCategoryMetaData preFatalData
                 = new DefaultLogMetaData.LogCategoryMetaData(preDefaultLogData);
            preFatalData.setOutput(
                ServiceManagerFactory.DEFAULT_LOGGER.isSystemFatalEnabled()
            );
            ServiceManagerFactory.DEFAULT_LOGGER
                .setSystemFatalEnabled(categoryData.isOutput());
            preDefaultLogData.setFatal(preFatalData);
            if(ServiceManagerFactory.DEFAULT_LOGGER.isSystemFatalEnabled()){
                logger.write(SVCL_00012, DefaultLoggerService.SYSTEM_FATAL_CATEGORY_LABEL);
            }else{
                logger.write(SVCL_00013, DefaultLoggerService.SYSTEM_FATAL_CATEGORY_LABEL);
            }
        }else{
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(true);
        }
    }
    
    /**
     * T[oLogger̐ݒftHg̐ݒɖ߂B<p>
     *
     * @param defaultLogData T[rX`&lt;default-log&gt;vf^f[^
     */
    protected void undeployDefaultLogMetaData(
        DefaultLogMetaData defaultLogData
    ){
        if(defaultLogData == null && preDefaultLogData == null){
            return;
        }
        if(preDefaultLogData.getDebug() != null){
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(
                preDefaultLogData.getDebug().isOutput()
            );
        }
        if(preDefaultLogData.getInformation() != null){
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(
                preDefaultLogData.getInformation().isOutput()
            );
        }
        if(preDefaultLogData.getWarning() != null){
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(
                preDefaultLogData.getWarning().isOutput()
            );
        }
        if(preDefaultLogData.getError() != null){
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(
                preDefaultLogData.getError().isOutput()
            );
        }
        if(preDefaultLogData.getFatal() != null){
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(
                preDefaultLogData.getFatal().isOutput()
            );
        }
    }
    
    /**
     * T[rX`&lt;property-editors&gt;vfŒ`ꂽjava.beans.PropertyEditor[hāAjava.beans.PropertyEditorManagerɓo^B<p>
     */
    @SuppressWarnings("unchecked")
    protected void deployPropertyEditors(){
        final Logger logger = getLogger();
        
        logger.write(SVCL_00014);
        
        final Map<String, String> propertyEditors = serverData.getPropertyEditors();
        final ClassLoader loader = NimbusClassLoader.getInstance();
        for(Map.Entry<String, String> entry : propertyEditors.entrySet()){
            final String typeName = entry.getKey();
            final String editorClassName = entry.getValue();
            
            Class<?> type = null;
            Class<PropertyEditor> editorClass = null;
            try{
                type = Class.forName(typeName, true, loader);
            }catch(ClassNotFoundException e){
                logger.write(SVCL_00015, e, typeName);
                continue;
            }
            try{
                editorClass = (Class<PropertyEditor>)Class.forName(editorClassName, true, loader);
            }catch(ClassNotFoundException e){
                logger.write(SVCL_00016, e, editorClassName);
                continue;
            }
            this.propertyEditors.add(type, editorClass);
            logger.write(SVCL_00017, type, editorClass);
        }
    }
    
    /**
     * T[rX`&lt;manager&gt;vf^f[^zuB<p>
     *
     * @param managerData T[rX`&lt;manager&gt;vf^f[^
     * @exception DeploymentException T[rX`̐ݒɌ肪ꍇ
     */
    @SuppressWarnings("unchecked")
    protected void deployManagerMetaData(ManagerMetaData managerData)
     throws DeploymentException{
        final Logger logger = getLogger();
        
        logger.write(SVCL_00018, managerData);
        
        final String name = managerData.getName();
        ServiceManager manager = ServiceManagerFactory.findManager(name);
        if(manager == null){
            manager = managerMap.get(name);
        }
        if(manager == null){
            String managerClassName = managerData.getCode();
            if(managerClassName == null){
                managerClassName = serviceManagerClassName;
            }
            try{
                final Class<ServiceManager> clazz = (Class<ServiceManager>)Class.forName(
                    managerClassName,
                    true,
                    NimbusClassLoader.getInstance()
                );
                manager = clazz.newInstance();
            }catch(Exception e){
                final MessageRecordFactory message = getMessageRecordFactory();
                throw new DeploymentException(
                    message.findMessage(SVCL_00019, name),
                    e
                );
            }
            manager.setServiceName(name);
            manager.setServiceManagerName(name);
            logger.write(SVCL_00020, name);
        }
        managerMap.put(name, manager);
        
        manager.deploy(managerData);
    }
    
    /**
     * ̃[_Ń[hꂽT[rX̓ŁAw肳ꂽServiceManagerɓo^ꂽT[rX̐AJnsB<p>
     * ServiceManagerjĂԂ̏ꍇ́A{@link ServiceManager#create()}A{@link ServiceManager#start()}ĂяoB<br>
     * ServiceManager~ĂԂ̏ꍇ́A{@link ServiceManager#start()}ĂяoB<br>
     * ServiceManagerJnĂԂ̏ꍇ́Ã[_Ń[hꂽT[rX{@link ServiceManager#createService(Set)}A{@link ServiceManager#startService(Set)}ĂяoĐAJnB<br>
     * ServiceManagerĂԂ̏ꍇ́A{@link ServiceManager#start()}ĂяoB<br>
     * ܂AServiceManagerJnĂȂԂ̏ꍇŁA&lt;manager&gt;vfshutdown-hooktruȅꍇ́AVM̏ItbN{@link ServiceManager#stop()}A{@link ServiceManager#destroy()}ĂяoXbhA{@link Runtime#addShutdownHook(Thread)}Őݒ肷B<br>
     *
     * @param manager AJnServiceManager
     * @exception Exception ServiceManager̐AJnɎsꍇ
     */
    private void startupServiceManager(final ServiceManager manager)
     throws Exception{
        final Logger logger = getLogger();
        final State state = manager.getState();
        if(state != State.STARTED){
            if(state == State.DESTROYED){
                manager.create();
            }
            manager.start();
            
            final ManagerMetaData managerData
                 = serverData.getManager(manager.getServiceName());
            if(managerData.isExistShutdownHook()){
                final String managerName = manager.getServiceName();
                if(shutdownHooks.containsKey(managerName)){
                    Runtime.getRuntime().removeShutdownHook(
                        (Thread)shutdownHooks.get(managerName)
                    );
                }
                final Thread shutdownHook = new Thread(
                    new Runnable(){
                        public void run(){
                            manager.stop();
                            manager.destroy();
                        }
                    }
                );
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                shutdownHooks.put(manager.getServiceName(), shutdownHook);
                logger.write(SVCL_00026, manager.getServiceName());
            }
        }else{
            final ManagerMetaData managerData
                 = serverData.getManager(manager.getServiceName());
            final Set<String> serviceNames = new HashSet<String>(
                managerData.getServices().keySet()
            );
            manager.createService(serviceNames);
            manager.startService(serviceNames);
        }
    }
    
    /**
     * ̃[_Ń[hꂽT[rX̓ŁAw肳ꂽServiceManagerɓo^ꂽT[rX̒~AjsB<p>
     * ̃[_Ń[hꂽT[rX̓ŁAw肳ꂽServiceManagerɓo^ꂽT[rX{@link ServiceManager#destroyService(Set)}Œ~AjB<br>
     * ̌Aw肳ꂽServiceManagerɁÃ[_Ń[hꂽT[rXo^ĂȂꍇ́A{@link ServiceManager#stop()}A{@link ServiceManager#destroy()}ĂяoAServiceManagerg~AjB܂AVbg_EtbNݒ肳Ăꍇ́AB<br>
     *
     * @param manager ServiceManagerIuWFNg
     */
    private void shutdownServiceManager(ServiceManager manager){
        final ManagerMetaData managerData
             = serverData.getManager(manager.getServiceName());
        final Set<String> serviceNames = new HashSet<String>(
            managerData.getServices().keySet()
        );
        manager.destroyService(serviceNames);
        manager.undeploy(managerData);
        
        if(manager.getManagerMetaDataSet().size() == 0){
            manager.stop();
            final Thread hook
                 = (Thread)shutdownHooks.remove(manager.getServiceName());
            if(hook != null){
                try{
                    Runtime.getRuntime().removeShutdownHook(hook);
                }catch(IllegalStateException e){}
            }
            manager.destroy();
        }
    }
    
    protected class MyErrorHandler implements ErrorHandler{
        
        private boolean isError;
        
        @Override
        public void warning(SAXParseException e) throws SAXException{
            getLogger().write(
                SVCL_00030,
                e.getMessage(), e.getLineNumber(), e.getColumnNumber()
            );
        }
        @Override
        public void error(SAXParseException e) throws SAXException{
            isError = true;
            getLogger().write(
                SVCL_00031,
                e.getMessage(), e.getLineNumber(), e.getColumnNumber()
            );
        }
        @Override
        public void fatalError(SAXParseException e) throws SAXException{
            isError = true;
            getLogger().write(
                SVCL_00032,
                e.getMessage(),e.getLineNumber(), e.getColumnNumber()
            );
        }
        public boolean isError(){
            return isError;
        }
    }
}
