/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.Date;
import java.sql.Timestamp;


/**
 * {@link Timestamp}^PropertyEditorNXB<p>
 * tiyyyy/MM/dd HH:mm:ss SSSjjava.util.Timestamp^̃IuWFNgɕϊB<br>
 * "${""}"Ɉ͂܂ꂽ́ÃVXevpeBƒuB<br>
 * <p>
 * F<br>
 * &nbsp;&nbsp;2006/08/15 15:20:11 100<br>
 * <br>
 * ̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;new Timestamp(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS").parse("2006/08/15 15:20:11 100").getTime())<br>
 * <br>
 * ̂悤ɕϊB<br>
 * ܂Aݒ肷Kv̂ȂtB[h͋ɂƁÃtB[h̍ŏlɐݒ肳B<br>
 * F<br>
 * &nbsp;&nbsp;//15 15::11<br>
 * <br>
 * ̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;new Timestamp(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS").parse("1970/01/15 15:00:11 000").getTime())<br>
 * <br>
 * ̂悤ɕϊB<br>
 * ܂Aݎݒ肵ꍇ́AetB[h"NOW"ݒ肷B<br>
 * F<br>
 * &nbsp;&nbsp;NOW/NOW/15 15:NOW:11 NOW<br>
 * <br>
 * ̂悤ȕ񂪁Aݓt2006/09/01 13:59:40 150Ƃ<br>
 * <br>
 * &nbsp;&nbsp;new Timestamp(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS").parse("2006/09/15 15:59:11 150").getTime())<br>
 * <br>
 * ̂悤ɕϊB<br>
 * ܂APɌݎݒ肵ꍇ́A"NOW"ݒ肷B<br>
 * F<br>
 * &nbsp;&nbsp;NOW<br>
 * <br>
 * ̂悤ȕ񂪁A<br>
 * <br>
 * &nbsp;&nbsp;new Timestamp(System.currentTimeMillis())<br>
 * <br>
 * ̂悤ɕϊB<br>
 *
 * @author M.Takata
 */
public class TimestampEditor extends DateEditor
 implements java.io.Serializable{
    
    private static final long serialVersionUID = -8460152792331112919L;
    
    /**
     * w肳ꂽ͂ăvpeBlݒ肷B<p>
     *
     * @param text ͂镶
     */
    @Override
    public void setAsText(String text){
        super.setAsText(text);
        Date date = (Date)super.getValue();
        if(date != null){
            super.setValue(new Timestamp(date.getTime()));
        }
    }
}
