/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.util.*;
import java.beans.*;
import java.io.*;

/**
 * Stringz^PropertyEditorNXB<p>
 * J}؂̕java.lang.String[]^̃IuWFNgɕϊBJ}Zp[^ł͂ȂƂĎw肵ꍇ́A""ŃGXP[vB<br>
 * ŏƍŌ̋󔒂ƉsŐ󔒂̓gB
 * 󔒂́A{@link java.lang.Character#isWhitespace(char)}Ŕ肳B
 * AA󔒂𕶎̑Oɕtꍇɂ́A"ň͂ނƃgȂB"𕶎̗[ɈӐ}Iɕtꍇɂ́A"dɏd˂ċLqB<br>
 * "&lt;!--""--&gt;"Ɉ͂܂ꂽ̓RgƉ߂ꖳB<br>
 * "${""}"Ɉ͂܂ꂽ́ÃVXevpeBƒuB<br>
 * "${\t}"A"${\n}"A"${\r}"A"${\f}"́AGXP[vV[PXƂĒuB<br>
 * "u"n܂ÚAjR[hƂĒuB<br>
 * <p>
 * F<br>
 * &nbsp;&nbsp;A,B, C  <br>
 * &nbsp;&nbsp;C, D,E ,&lt;!--F,<br>
 * &nbsp;&nbsp;G,--&gt;"H ",""I""<br>
 * <br>
 * &nbsp;̂悤ȕ<br>
 * <br>
 * &nbsp;&nbsp;new String[]{"A", "B", " CC", " D", "E ", "H ", "\"I\""}<br>
 * <br>
 * &nbsp;̂悤ɕϊB<br>
 *
 * @author M.Takata
 */
public class StringArrayEditor extends PropertyEditorSupport
 implements java.io.Serializable{
    
    private static final long serialVersionUID = 1849102862712070203L;
    
    /**
     * w肳ꂽ͂ăvpeBlݒ肷B<p>
     *
     * @param text ͂镶
     */
    @Override
    public void setAsText(String text){
        if(text == null){
            setValue(null);
            return;
        }
        final String tmpText = jp.ossc.nimbus.core.Utility.replaceSystemProperty(Utility.xmlComentOut(text), false);
        final int length = tmpText.length();
        if(length == 0){
            setValue(new String[0]);
            return;
        }
        final StringReader sr = new StringReader(tmpText);
        final BufferedReader br = new BufferedReader(sr, length);
        final List<String> list = new ArrayList<String>();
        try{
            StringBuilder buf = new StringBuilder();
            String line = null;
            while((line = br.readLine()) != null){
                final String val = Utility.trim(line);
                boolean isEscape = false;
                for(int i = 0, max = val.length(); i < max; i++){
                    final char c = val.charAt(i);
                    switch(c){
                    case ',':
                        if(isEscape){
                            buf.append(c);
                            isEscape = false;
                        }else if(buf.length() != 0){
                            String tmp = trimDoubleQuote(buf);
                            if(tmp.indexOf('\\') != -1){
                                tmp = Utility.unicodeConvert(tmp);
                            }
                            list.add(tmp);
                            buf.setLength(0);
                        }
                        break;
                    case '\\':
                        if(isEscape){
                            buf.append(c);
                            isEscape = false;
                        }else{
                            isEscape = true;
                        }
                        break;
                    default:
                        if(isEscape){
                            buf.append('\\');
                            isEscape = false;
                        }
                        buf.append(c);
                    }
                }
            }
            if(buf.length() != 0){
                String tmp = trimDoubleQuote(buf);
                if(tmp.indexOf('\\') != -1){
                    tmp = Utility.unicodeConvert(tmp);
                }
                list.add(tmp);
                buf.setLength(0);
            }
        }catch(IOException e){
            // NȂ͂
            e.printStackTrace();
        }finally{
            try{
                br.close();
            }catch(IOException e){
                // NȂ͂
                e.printStackTrace();
            }
            sr.close();
        }
        setValue(list.toArray(new String[list.size()]));
    }
    
    private String trimDoubleQuote(StringBuilder buf){
        if(buf != null && buf.length() > 1
             && buf.charAt(0) == '"' && buf.charAt(buf.length() - 1) == '"'){
            return buf.substring(1, buf.length() - 1);
        }
        return buf.toString();
    }
    
    /**
     * vpeB擾B<p>
     *
     * @return vpeB
     */
    @Override
    public String getAsText(){
        final String[] strArray = (String[])getValue();
        if(strArray == null){
            return null;
        }
        final StringBuilder buf = new StringBuilder();
        for(int i = 0, max = strArray.length; i < max; i++){
            String str = strArray[i];
            str = str.replaceAll(",", "\\\\,");
            buf.append(str);
            if(i != max - 1){
                buf.append(',');
            }
        }
        return buf.toString();
    }
}
