---
title: "Welcome our new team member, Arne Döring!"
author: Nim Team
excerpt: "We are glad that Arne Döring joined us as a fulltime core Nim developer."
---

Arne has been programming in Nim for quite some time now and has also contributed
valuable patches before, especially regarding Nim's macro system. Now that he
has completed his master thesis about how to leverage Nim's macro system to generate
shader programs for graphical applications, he is ready to take the full dive
into Nim's core, the compiler and its libraries.

Interestingly he wrote all the code for his master thesis in Nim and argued in
detail that C++ would have been unfeasible. Shader programs are separate from
ordinary native code and this means usually you are programming in a mixed
language environment with all its known downsides like the difficulty to
debug, the violations of DRY and the mental overhead of having to switch between
two different programming languages.

Nim allows you to tackle these problems via its powerful macro system. Arne
developed a Nim to GLSL compiler entirely with macros. A subset of Nim is
translated to GLSL code but his compiler also produces automatic interfacing
code between the "native Nim world" and the "Nim shader world". This interfacing
code usually has to be written manually and is an error prone, type unsafe task.
Nim allowed Arne to automate this critical step in realtime graphics programming,
we let the results speak for themselves:

<iframe width="752" height="424" src="https://www.youtube.com/embed/_Hiamk2O3aM?start=192" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>

All of these demos were created with a fraction of the code that a solution in
C/C++ or most other common programming languages would require, the Nim code
is small, easy to read and type safe.

Arne's mission is not only core Nim development but also involves improving
the tooling around Nim, especially Nim's debugging support. He started with
giving Nim a frequently requested feature; `sizeof` can now be evaluated at
compiletime by the Nim compiler, previously this expression was delegated to
the C compiler. As a nice bonus, Arne also added `alignof` and `offsetof`
builtins.

[We are still hiring.](https://nim-lang.org/blog/2018/09/11/nim-is-hiring.html)
