package jp.sourceforge.nicoro.test;

import jp.sourceforge.nicoro.BinUtil;
import android.test.MoreAsserts;
import junit.framework.TestCase;

public class BinUtilTests extends TestCase {

	@Override
	protected void setUp() throws Exception {
		super.setUp();
	}
	
	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void testToBinaryFromBytes1() {
		byte[] binary;
		binary = BinUtil.toBinaryFromBytes(new byte[]{ 0 }, 0, 0);
		MoreAsserts.assertEquals(new byte[]{}, binary);
		
		binary = BinUtil.toBinaryFromBytes(new byte[]{ (byte) 0xff }, 0, 1);
		MoreAsserts.assertEquals(new byte[]{ 1 }, binary);
		
		binary = BinUtil.toBinaryFromBytes(new byte[]{ 0 }, 0, 8);
		MoreAsserts.assertEquals(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 0 }, binary);
		
		binary = BinUtil.toBinaryFromBytes(new byte[]{ (byte) 0xff }, 0, 8);
		MoreAsserts.assertEquals(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, binary);
		
		binary = BinUtil.toBinaryFromBytes(new byte[]{ (byte) 0x80 }, 0, 8);
		MoreAsserts.assertEquals(new byte[]{ 1, 0, 0, 0, 0, 0, 0, 0 }, binary);
		
		binary = BinUtil.toBinaryFromBytes(new byte[]{ 0x01, (byte) 0x80 }, 7, 2);
		MoreAsserts.assertEquals(new byte[]{ 1, 1 }, binary);
		
		binary = BinUtil.toBinaryFromBytes(new byte[]{ 0x01, (byte) 0x80 }, 0, 16);
		MoreAsserts.assertEquals(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 1, 
				1, 0, 0, 0, 0, 0, 0, 0, 
		}, binary);
	}
	
	public void testToByteFromBinary() {
		byte b;
		b = BinUtil.toByteFromBinary(new byte[]{}, 0, 0);
		assertEquals(0, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 0);
		assertEquals(0, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 8);
		assertEquals((byte) 0xff, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 1, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals((byte) 0x80, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1 }, 0, 8);
		assertEquals(0x01, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 4, 4);
		assertEquals(0x01, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 4, 4);
		assertEquals(0x08, b);
		
		b = BinUtil.toByteFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0 }, 5, 7);
		assertEquals(0x2c, b);
	}
	
	public void testToIntFromBinary() {
		int i;
		i = BinUtil.toIntFromBinary(new byte[]{}, 0, 0);
		assertEquals(0, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 0);
		assertEquals(0, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 8);
		assertEquals(0xff, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 1, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0x80, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1 }, 0, 8);
		assertEquals(0x01, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 4, 4);
		assertEquals(0x01, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 4, 4);
		assertEquals(0x08, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0 }, 5, 7);
		assertEquals(0x2c, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 0);
		assertEquals(0, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
		}, 0, 32);
		assertEquals(0, i);
		
		i = BinUtil.toIntFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 32);
		assertEquals(0xffffffff, i);
	}
	
	public void testToSIntFromBinary() {
		int i;
		i = BinUtil.toSIntFromBinary(new byte[]{}, 0, 0);
		assertEquals(0, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 0);
		assertEquals(0, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 8);
		assertEquals(-1, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 1, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(-128, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1 }, 0, 8);
		assertEquals(0x01, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 4, 4);
		assertEquals(0x01, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 4, 4);
		assertEquals(-8, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0 }, 5, 7);
		assertEquals(0x2c, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 0);
		assertEquals(0, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
		}, 0, 32);
		assertEquals(0, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 32);
		assertEquals(-1, i);
		
		i = BinUtil.toSIntFromBinary(new byte[]{
				0, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 32);
		assertEquals(0x7fffffff, i);
	}
	
	public void testToLongFromBinary() {
		long l;
		l = BinUtil.toLongFromBinary(new byte[]{}, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 8);
		assertEquals(0xff, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 1, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0x80, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1 }, 0, 8);
		assertEquals(0x01, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 4, 4);
		assertEquals(0x01, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 4, 4);
		assertEquals(0x08, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0 }, 5, 7);
		assertEquals(0x2c, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
		}, 0, 32);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 32);
		assertEquals(0xffffffff, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
		}, 0, 64);
		assertEquals(0, l);
		
		l = BinUtil.toLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 64);
		assertEquals(0xffffffffffffffffL, l);
	}
	
	public void testToSLongFromBinary() {
		long l;
		l = BinUtil.toSLongFromBinary(new byte[]{}, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 1, 1, 1, 1, 1, 1, 1, 1 }, 0, 8);
		assertEquals(-1L, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 1, 0, 0, 0, 0, 0, 0, 0 }, 0, 8);
		assertEquals(-128L, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1 }, 0, 8);
		assertEquals(0x01, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 4, 4);
		assertEquals(0x01, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 4, 4);
		assertEquals(-8L, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{ 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0 }, 5, 7);
		assertEquals(0x2c, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
		}, 0, 32);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 32);
		assertEquals(-1L, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 0);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0,
		}, 0, 64);
		assertEquals(0, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 64);
		assertEquals(-1L, l);
		
		l = BinUtil.toSLongFromBinary(new byte[]{
				0, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
		}, 0, 32);
		assertEquals(0x7fffffffL, l);
	}

}
