package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptJumpMarkerTest extends TestCase {
    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("", 123, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ジャンプマーカー：しおり", chat);
        assertEquals(NicoScriptJumpMarker.class, ns.getClass());

        NicoScriptJumpMarker script = (NicoScriptJumpMarker) ns;

        assertEquals(123, script.getVpos());
        assertEquals("しおり", script.getMarkerLabel());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptJumpMarker);
        assertFalse(fake.calledAddCommandJumpMarker);

        script.onDraw(fake);
        assertEquals(script, fake.scriptJumpMarker);
        assertTrue(fake.calledAddCommandJumpMarker);
    }

}
