package jp.gr.java_conf.shiseissi.commonlib;

import java.util.ArrayList;
import java.util.HashMap;

/**
 *
 * @author shisei
 */
public abstract class CollUtil {

    /**
     * 型推論を使用したHashMapの生成
     * @param <K>
     * @param <V>
     * @return
     */
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap<K, V>();
    }

    /**
     * 型推論を使用したHashMapの生成
     * @param <K>
     * @param <V>
     * @param capacity	the initial capacity of this {@code HashMap}.
     * @return
     */
    public static <K, V> HashMap<K, V> newHashMap(int capacity) {
        return new HashMap<K, V>(capacity);
    }

    /**
     * 型推論を使用したArrayListの生成
     * @param <K>
     * @param <V>
     * @return
     */
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList<E>();
    }

    /**
     * 型推論を使用したArrayListの生成
     * @param <K>
     * @param <V>
     * @param capacity	the initial capacity of this {@code ArrayList}.
     * @return
     */
    public static <E> ArrayList<E> newArrayList(int capacity) {
        return new ArrayList<E>(capacity);
    }

}
