package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;

public class DefineSprite {

    public short spriteID; // UI16
    public int frameCount; // UI16

    // TODO ControlTagsへのリンクが未実装

    public int read(byte[] bufferArray, int offset) {
        DefineSprite defineSprite = this;

        defineSprite.spriteID =
            (short) ((bufferArray[offset + 0] & 0xff) | ((bufferArray[offset + 1] & 0xff) << 8));
        defineSprite.frameCount =
            ((bufferArray[offset + 2] & 0xff) | ((bufferArray[offset + 3] & 0xff) << 8));

        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("DefineSprite: spriteID=")
                    .append(defineSprite.spriteID & 0xffff)
                    .append(" frameCount=").append(defineSprite.frameCount)
                    .toString());
        }
        return offset;
    }

}
