package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.os.StatFs;

public class StorageInfo {
    private long mAvailableBytes;

    public StorageInfo(String dir) {
        try {
            StatFs st = new StatFs(dir);
            mAvailableBytes = st.getBlockSize() * (long) st.getAvailableBlocks();

        } catch (IllegalArgumentException e) {
            Log.w(LOG_TAG, e.toString(), e);
            mAvailableBytes = -1;
        }
    }

    /**
     *
     * @return 指定ディレクトリがあるストレージの空き容量（バイトサイズ）。
     * 取得失敗時は-1
     */
    public long getAvailableBytes() {
        return mAvailableBytes;
    }

    public String getAvailable() {
        if (mAvailableBytes < 0) {
            return "--- MB";
        }
        if (mAvailableBytes >= 1024 * 1024 * 1024) {
            double gb = (double) mAvailableBytes / (1024 * 1024 * 1024);
            return String.format("%.3f GB", gb);
        } else {
            long mb = mAvailableBytes / (1024 * 1024);
            return String.format("%d MB", mb);
        }
    }
}
