package jp.sourceforge.nicoro;

import jp.sourceforge.nicoro.IVideoCacheServiceCallback;

interface IVideoCacheService {
	int getContentLength(String videoV, int ecoType);
	int getProgress(String videoV, int ecoType);
	/**
	 * 指定動画番号のキャッシュ実行を停止させる<BR>
	 * 場合によっては数秒以上の時間がかかるおそれがある
	 * @param videoV
	 */
	void stopCache(String videoV);
	int getCacheState(String videoV, int ecoType);
	void addStartCache(String videoV, int forceEco);
	int getWaitRequestSize();
	void clearNotification(String videoV);
	void deleteCache(String videoV);
	void deleteAllCache();

	void addListener(IVideoCacheServiceCallback callback);
	void removeListener(IVideoCacheServiceCallback callback);
}
