package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChat;
import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptDefaultTest extends TestCase {
    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@120 red small ue", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠デフォルト", chat);
        assertEquals(NicoScriptDefault.class, ns.getClass());

        NicoScriptDefault script = (NicoScriptDefault) ns;
        assertEquals(MessageChat.COLOR_RED, script.getColor());
        assertEquals(MessageChat.FONTSIZE_PX_SMALL, script.getFontSize());
        assertEquals(MessageChat.FONTSIZE_TYPE_SMALL, script.getFontSizeType());
        assertEquals(MessageChat.POS_UE, script.getPos());
        assertEquals(120, chat.getTime());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptDefault);
        assertFalse(fake.calledSetCommandDefault);
        assertFalse(fake.calledClearCommandDefault);

        script.onDraw(fake);
        assertEquals(script, fake.scriptDefault);
        assertTrue(fake.calledSetCommandDefault);
        assertFalse(fake.calledClearCommandDefault);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptDefault);
        assertTrue(fake.calledClearCommandDefault);
    }

    public void testNotSetTime() {
        MessageChatFork chat = new MessageChatFork("red small ue", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠デフォルト", chat);
        assertEquals(NicoScriptDefault.class, ns.getClass());

        NicoScriptDefault script = (NicoScriptDefault) ns;
        assertEquals(MessageChat.COLOR_RED, script.getColor());
        assertEquals(MessageChat.FONTSIZE_PX_SMALL, script.getFontSize());
        assertEquals(MessageChat.FONTSIZE_TYPE_SMALL, script.getFontSizeType());
        assertEquals(MessageChat.POS_UE, script.getPos());
        assertEquals(Integer.MAX_VALUE, chat.getTime());
    }
}
