package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;
import android.graphics.Color;

public class LINESTYLE {
	public int width;		// UI16
	public int color;		// RGB (Shape1 or Shape2), RGBA (Shape3)

    public int read(byte[] bufferArray, int offset, int tagType) {
    	LINESTYLE lineStyle = this;

		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("readLINESTYLE: offset=")
					.append(offset).toString());
		}

		lineStyle.width =
			((bufferArray[offset + 0] & 0xff) | ((bufferArray[offset + 1] & 0xff) << 8));
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, Log.buf().append("Width=")
    				.append(lineStyle.width).toString());
    	}

    	int offsetNext = offset + 2;
		switch (tagType) {
		case RECORDHEADER.SWFTAG_DEFINESHAPE:
		case RECORDHEADER.SWFTAG_DEFINESHAPE2:
			lineStyle.color = Color.rgb(
					bufferArray[offsetNext + 0],
					bufferArray[offsetNext + 1],
					bufferArray[offsetNext + 2]);
			offsetNext += 3;
			break;
		case RECORDHEADER.SWFTAG_DEFINESHAPE3:
			lineStyle.color = Color.argb(
					bufferArray[offsetNext + 3],
					bufferArray[offsetNext + 0],
					bufferArray[offsetNext + 1],
					bufferArray[offsetNext + 2]);
			offsetNext += 4;
			break;
		default:
			Log.w(LOG_TAG, Log.buf().append("LINESTYLE: record tag type mismatch=")
					.append(tagType).toString());
			break;
		}
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, Log.buf().append("Color=")
    				.append(Integer.toHexString(lineStyle.color)).toString());
    	}

		return offsetNext;
    }

}
