package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

//TODO とりあえずparseだけでメイン動作は後で実装
//TODO @button考慮

public class NicoScriptScore extends NicoScript
implements NicoScript.NicosOrLocal {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    protected static final String COMMAND_PREFIX = "スコア";

    private final Label mLabel = new Label();
    private int mScore;

    private final SingleKeyword mSingleKeyword = new SingleKeyword();

    protected NicoScriptScore(MessageChatFork chat, String commandMain,
            CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }

        mScore = 10;

        mLabel.setLabel(commandMain);

        mSingleKeyword.setKeyword(commandSplitter.getNextCommand());

        String score = commandSplitter.getNextCommand();
        if (score == null) {
            return;
        }
        try {
            mScore = getInt(score);
        } catch (NumberFormatException e) {
            Log.e(LOG_TAG, e.toString(), e);
        }

        String agreeEntirely = commandSplitter.getNextCommand();
        if (agreeEntirely == null) {
            return;
        }
        if (!mSingleKeyword.setAgreeEntirely(agreeEntirely)) {
            Log.w(LOG_TAG, Log.buf().append("invalid Vote: agreeEntirely=")
                    .append(agreeEntirely).toString());
            return;
        }
    }

    @Override
    public boolean isSaveLocal() {
        return mChat.isSaveLocal();
    }

    @Override
    public boolean match(String text) {
        return mSingleKeyword.match(text);
    }

    public String getLabel() {
        return mLabel.getLabel();
    }
    public int getScore() {
        return mScore;
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.removeCommandScore(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript Score: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.addCommandScore(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript Score: ")
                    .append(mChat).toString());
        }
    }
}
