package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;

//TODO とりあえずparseだけでメイン動作は後で実装
//TODO @button考慮

public class NicoScriptBall extends NicoScript
implements NicoScript.NicosOrLocal, NicoScript.GetStyleSide {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    protected static final String COMMAND_PREFIX = "玉";

    private final Label mLabel = new Label();
    private final MultiKeyword mMultiKeyword = new MultiKeyword();

    protected NicoScriptBall(MessageChatFork chat, String commandMain,
            CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }

        mLabel.setLabel(commandMain);

        String keyword = commandSplitter.getNextCommand();
        if (keyword == null) {
            mMultiKeyword.setKeyword("上、下、左、右");
            return;
        }
        mMultiKeyword.setKeyword(keyword);

        // TODO 移動量ちゃんと解析
        String move = commandSplitter.getNextCommand();
        if (move == null) {
            move = "20,20,20,20";
            return;
        }

        String agreeEntirely = commandSplitter.getNextCommand();
        if (agreeEntirely == null) {
            return;
        }
        if (!mMultiKeyword.setAgreeEntirely(agreeEntirely)) {
            Log.w(LOG_TAG, Log.buf().append("invalid Ball: agreeEntirely=")
                    .append(agreeEntirely).toString());
            return;
        }
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.removeCommandBall(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript Ball: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.addCommandBall(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript Ball: ")
                    .append(mChat).toString());
        }
    }

    @Override
    public boolean isSaveLocal() {
        return mChat.isSaveLocal();
    }

    @Override
    public boolean match(String text) {
        return mMultiKeyword.match(text);
    }

    public String getLabel() {
        return mLabel.mLabel;
    }

    @Override
    public int getColor() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getFontSize() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getFontSizeType() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getPos() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getLineHeight() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }

    @Override
    public int getPosSide() {
        // TODO 自動生成されたメソッド・スタブ
        return 0;
    }
}
