package jp.sourceforge.nicoro;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AnalogClock;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;

public class PlayerInfoMiniViews {
    private VariableLabelView mInfoTime;
    private AnalogClock mInfoClock;
    private VariableLabelView mInfoBattery;
    private PlayerInfoMiniLayout mPlayerInfoMini;

    private String mResStrBat;

    public void initializeView(Activity activity) {
        View root = activity.getWindow().getDecorView();
        initializeView(root);
    }

    public void initializeView(View root) {
        mPlayerInfoMini = ViewUtil.findViewById(root, R.id.player_info_mini);
        mInfoClock = ViewUtil.findViewById(root, R.id.info_mini_clock);
        mInfoTime = ViewUtil.findViewById(root, R.id.info_mini_time);
        mInfoBattery = ViewUtil.findViewById(root, R.id.info_mini_battery);

        mResStrBat = mInfoBattery.getContext().getString(R.string.bat);
    }

    public void copyLayoutParamsFrom(ViewGroup src) {
        ViewUtil.copyLayoutParamsById(mInfoClock, src);
        ViewUtil.copyLayoutParamsById(mInfoTime, src);
        int bottomMargin = 0;
        ViewGroup.LayoutParams params = mPlayerInfoMini.getLayoutParams();
        if (params instanceof ViewGroup.MarginLayoutParams) {
            bottomMargin = ((ViewGroup.MarginLayoutParams) params).bottomMargin;
        }
        ViewUtil.copyLayoutParamsById(mPlayerInfoMini, src);
        if (bottomMargin != 0) {
            params = mPlayerInfoMini.getLayoutParams();
            if (params instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams) params).bottomMargin = bottomMargin;
            }
        }
    }

    /**
     *
     * @param appender
     * @return 文字列生成後のStringBuilder
     */
    public StringBuilder setTime(PlayerInfoDialogFragment.TimeAppender appender) {
        StringBuilder infoTimeData = mInfoTime.getTextBuilderWithClear();
        appender.appendCurrentPlayTime(infoTimeData);
        if (appender.hasTotalPlayTime()) {
            infoTimeData.append('/');
            appender.appendTotalPlayTime(infoTimeData);
        }
        mInfoTime.notifyUpdateText();
        return infoTimeData;
    }

    public PlayerInfoMiniLayout getInfoMiniView() {
        return mPlayerInfoMini;
    }
    public View getTimeView() {
        return mInfoTime;
    }

    public void updateBattery(int level, int scale) {
        if (mInfoBattery == null) {
            return;
        }
        StringBuilder builder = mInfoBattery.getTextBuilderWithClear();
        builder.append(mResStrBat).append(": ");
        if (level >= 0 && scale > 0) {
            if (scale != 100) {
                level = level * scale / 100;
            }
            builder.append(level);
        } else {
            builder.append("???");
        }
        builder.append("%");
        mInfoBattery.notifyUpdateText();
    }
}
