package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptVoteTest extends TestCase {

    // TODO 後で追加実装すべきテストあり（styleとか）

    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠投票 キーワード", chat);
        assertEquals(NicoScriptVote.class, ns.getClass());

        NicoScriptVote script = (NicoScriptVote) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        assertNull(script.getLabel());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptVote);
        assertFalse(fake.calledAddCommandVote);
        assertFalse(fake.calledRemoveCommandVote);

        script.onDraw(fake);
        assertEquals(script, fake.scriptVote);
        assertTrue(fake.calledAddCommandVote);
        assertFalse(fake.calledRemoveCommandVote);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptVote);
        assertTrue(fake.calledRemoveCommandVote);

    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@90 red small migi shita", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠投票：ラベル キー１、キー２", chat);
        assertEquals(NicoScriptVote.class, ns.getClass());

        NicoScriptVote script = (NicoScriptVote) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals("ラベル", script.getLabel());

        assertFalse(script.match("キー"));
        assertTrue(script.match("キー１"));
        assertTrue(script.match("キー２"));
        assertTrue(script.match("キー１です"));
        assertTrue(script.match("なんとキー２"));

        assertTrue(script.isProgressVisible());
        assertEquals("人", script.getUnit());
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@90 local red small migi shita", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠投票 キー", chat);
        assertEquals(NicoScriptVote.class, ns.getClass());

        NicoScriptVote script = (NicoScriptVote) ns;
        assertTrue(script.isSaveLocal());
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@90 red small migi shita", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠投票 キー 表示 億 部分一致", chat);
        assertEquals(NicoScriptVote.class, ns.getClass());

        NicoScriptVote script = (NicoScriptVote) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertNull(script.getLabel());

        assertTrue(script.match("キー"));
        assertTrue(script.match("家のキー"));

        assertTrue(script.isProgressVisible());
        assertEquals("億", script.getUnit());
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@90 red small migi shita", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠投票 キー 非表示 億 完全一致", chat);
        assertEquals(NicoScriptVote.class, ns.getClass());

        NicoScriptVote script = (NicoScriptVote) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertNull(script.getLabel());

        assertTrue(script.match("キー"));
        assertFalse(script.match("家のキー"));

        assertFalse(script.isProgressVisible());
        assertEquals("億", script.getUnit());
    }

}
