package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptJumpTests extends TestCase {
    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ジャンプ sm1", chat);
        assertEquals(NicoScriptJump.class, ns.getClass());

        NicoScriptJump script = (NicoScriptJump) ns;
        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptJump);
        assertFalse(fake.calledSetCommandJump);
        assertFalse(fake.calledClearCommandJump);

        script.onDraw(fake);
        assertEquals(script, fake.scriptJump);
        assertTrue(fake.calledSetCommandJump);
        assertFalse(fake.calledClearCommandJump);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptJump);
        assertTrue(fake.calledClearCommandJump);
    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ジャンプ sm1 次の動画へ", chat);
        assertEquals(NicoScriptJump.class, ns.getClass());

        NicoScriptJump script = (NicoScriptJump) ns;
        assertEquals(Integer.MAX_VALUE, chat.getTime());
        assertEquals("sm1", script.getJumpToVideoNumber());
        assertEquals(-1, script.getJumpToSecond());
        assertNull(script.getJumpToLabel());
        assertEquals("次の動画へ", script.getJumpMessage());
        assertEquals(-1, script.getJumpStartTimeSecond());
        assertEquals(-1, script.getReturnTimeSecond());
        assertNull(script.getReturnMessage());
    }

    public void testJumpTime() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ジャンプ #39:39 ｢みっく みく｣", chat);
        assertEquals(NicoScriptJump.class, ns.getClass());

        NicoScriptJump script = (NicoScriptJump) ns;
        assertEquals(90, chat.getTime());
        assertNull(script.getJumpToVideoNumber());
        assertEquals(2379, script.getJumpToSecond());
        assertNull(script.getJumpToLabel());
        assertEquals("みっく みく", script.getJumpMessage());
        assertEquals(-1, script.getJumpStartTimeSecond());
        assertEquals(-1, script.getReturnTimeSecond());
        assertNull(script.getReturnMessage());
    }

    public void testJumpLabel() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ジャンプ #マーカー", chat);
        assertEquals(NicoScriptJump.class, ns.getClass());

        NicoScriptJump script = (NicoScriptJump) ns;
        assertEquals(90, chat.getTime());
        assertNull(script.getJumpToVideoNumber());
        assertEquals(-1, script.getJumpToSecond());
        assertEquals("マーカー", script.getJumpToLabel());
        assertEquals(NicoScript.UNDEFINED_DEFAULT_JUMP_MESSAGE, script.getJumpMessage());
        assertEquals(-1, script.getJumpStartTimeSecond());
        assertEquals(-1, script.getReturnTimeSecond());
        assertNull(script.getReturnMessage());
    }

    public void testReturn() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ジャンプ sm1 次の動画へ 3:00 30 戻ります", chat);
        assertEquals(NicoScriptJump.class, ns.getClass());

        NicoScriptJump script = (NicoScriptJump) ns;
        assertEquals(90, chat.getTime());
        assertEquals("sm1", script.getJumpToVideoNumber());
        assertEquals(-1, script.getJumpToSecond());
        assertNull(script.getJumpToLabel());
        assertEquals("次の動画へ", script.getJumpMessage());
        assertEquals(180, script.getJumpStartTimeSecond());
        assertEquals(30, script.getReturnTimeSecond());
        assertEquals("戻ります", script.getReturnMessage());
    }
}
