package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChat;
import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptGyakuTest extends TestCase {
    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠逆", chat);
        assertEquals(NicoScriptGyaku.class, ns.getClass());

        NicoScriptGyaku script = (NicoScriptGyaku) ns;
        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptGyaku);
        assertFalse(fake.calledSetCommandGyaku);
        assertFalse(fake.calledClearCommandGyaku);

        script.onDraw(fake);
        assertEquals(script, fake.scriptGyaku);
        assertTrue(fake.calledSetCommandGyaku);
        assertFalse(fake.calledClearCommandGyaku);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptGyaku);
        assertTrue(fake.calledClearCommandGyaku);
    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠逆", chat);
        assertEquals(NicoScriptGyaku.class, ns.getClass());

        NicoScriptGyaku script = (NicoScriptGyaku) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        assertEquals(MessageChat.DIR_GYAKU, script.getDir(false));
        assertEquals(MessageChat.DIR_GYAKU, script.getDir(true));
    }

    public void testSube() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠逆 全", chat);
        assertEquals(NicoScriptGyaku.class, ns.getClass());

        NicoScriptGyaku script = (NicoScriptGyaku) ns;
        assertEquals(90, chat.getTime());
        assertEquals(MessageChat.DIR_GYAKU, script.getDir(false));
        assertEquals(MessageChat.DIR_GYAKU, script.getDir(true));
    }

    public void testComme() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠逆 コメ", chat);
        assertEquals(NicoScriptGyaku.class, ns.getClass());

        NicoScriptGyaku script = (NicoScriptGyaku) ns;
        assertEquals(MessageChat.DIR_GYAKU, script.getDir(false));
        assertEquals(MessageChat.DIR_NORMAL, script.getDir(true));
    }

    public void testTouComme() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠逆 投コメ", chat);
        assertEquals(NicoScriptGyaku.class, ns.getClass());

        NicoScriptGyaku script = (NicoScriptGyaku) ns;
        assertEquals(MessageChat.DIR_NORMAL, script.getDir(false));
        assertEquals(MessageChat.DIR_GYAKU, script.getDir(true));
    }
}
