package jp.sourceforge.nicoro.nicoscript;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.text.TextUtils;

import jp.sourceforge.nicoro.Log;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Release;
import jp.sourceforge.nicoro.Util;

//TODO @button考慮

public class NicoScriptKeywordJump extends NicoScript
implements NicoScript.Jump, NicoScript.NicosOrLocal {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    protected static final String COMMAND = "キーワードジャンプ";

    private final SingleKeyword mSingleKeyword = new SingleKeyword();

    private String mJumpTo;
    private int mJumpToSecond = -1;
    private String mJumpToLabel = null;
    private String mJumpMessage;
    private int mJumpStartTimeSecond = -1;
    private int mReturnTimeSecond = -1;
    private String mReturnMessage;

    public NicoScriptKeywordJump(MessageChatFork chat, CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(UNDEFINED_DEFAULT_TIME);
        }

        mSingleKeyword.setKeyword(commandSplitter.getNextCommand());

        mJumpTo = commandSplitter.getNextCommand();
        if (TextUtils.isEmpty(mJumpTo)) {
            return;
        }
        char ch0 = mJumpTo.charAt(0);
        if (ch0 == COMMAND_NUMBER_0 || ch0 == COMMAND_NUMBER_1) {
            String label = mJumpTo.substring(1);
            int time = getTimeSecond(label);
            if (time >= 0) {
                mJumpToSecond = time;
            } else {
                mJumpToLabel = label;
            }
        }
        mJumpMessage = commandSplitter.getNextCommandPhraze();
        if (mJumpMessage == null) {
            mJumpMessage = UNDEFINED_DEFAULT_JUMP_MESSAGE;
            return;
        }

        String cmd = commandSplitter.getNextCommand();
        for (; cmd != null; cmd = commandSplitter.getNextCommand()) {
            if (cmd.startsWith("同窓")) {
                // TODO 現状このアプリは窓一つなので無視
            } else if (cmd.startsWith("別窓")) {
                // TODO 現状このアプリは窓一つなので無視
            } else if (mSingleKeyword.setAgreeEntirely(cmd)) {
            } else {
                break;
            }
        }

        String jumpStartTime = cmd;
        if (jumpStartTime == null) {
            return;
        }
        mJumpStartTimeSecond = getTimeSecond(jumpStartTime);

        String returnTime = commandSplitter.getNextCommand();
        if (returnTime == null) {
            return;
        }
        mReturnTimeSecond = Util.parseInt(returnTime, -1);
        mReturnMessage = commandSplitter.getNextCommandPhraze();
    }

    @Override
    public String getJumpToVideoNumber() {
        if (mJumpToSecond >= 0 || mJumpToLabel != null) {
            return null;
        } else {
            return mJumpTo;
        }
    }

    @Override
    public int getJumpToSecond() {
        return mJumpToSecond;
    }

    @Override
    public String getJumpToLabel() {
        return mJumpToLabel;
    }

    @Override
    public String getJumpMessage() {
        return mJumpMessage;
    }

    @Override
    public int getJumpStartTimeSecond() {
        return mJumpStartTimeSecond;
    }

    @Override
    public int getReturnTimeSecond() {
        return mReturnTimeSecond;
    }

    @Override
    public String getReturnMessage() {
        return mReturnMessage;
    }

    @Override
    public boolean hasJumpMessage() {
        return mJumpMessage != UNDEFINED_DEFAULT_JUMP_MESSAGE;
    }

    @Override
    public boolean isSaveLocal() {
        return mChat.isSaveLocal();
    }

    @Override
    public boolean match(String text) {
        return mSingleKeyword.match(text);
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.removeCommandKeywordJump(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("End NicoScript KeywordJump: ")
                    .append(mChat).toString());
        }
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.addCommandKeywordJump(this);
        if (DEBUG_LOGD) {
            Log.d(LOG_TAG, Log.buf().append("Start NicoScript KeywordJump: ")
                    .append(mChat).toString());
        }
    }
}
