package jp.sourceforge.nicoro;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 一つの{@link Matcher}を何度も再利用するクラス<br>
 * <br>
 * 注意：同一スレッド上から使用すること
 */
public class ReuseMatcher {
    private final Matcher mMatcher;

    public ReuseMatcher(String pattern) {
        this(pattern, "");
    }
    public ReuseMatcher(String pattern, CharSequence input) {
        mMatcher = Pattern.compile(pattern).matcher(input);
    }

    public ReuseMatcher reset(CharSequence input) {
        mMatcher.reset(input);
        return this;
    }

    /**
     *
     * @param group
     * @return 前回matchしていればその値、そうでなければnull
     */
    public String groupIfFind(int group) {
        if (mMatcher.find()) {
            return mMatcher.group(group);
        } else {
            return null;
        }
    }

    public Matcher get() {
        return mMatcher;
    }
}
