package jp.sourceforge.nicoro;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class MessageData {
    private boolean mIsMessageOk;
    private List<MessageChat> mChatsWait = null;
    private List<MessageChat> mChatsRunningNaka = null;
    private List<MessageChat> mChatsRunningShita = null;
    private List<MessageChat> mChatsRunningUe = null;

    /**
     * MessageChatを待ち行列に設定し、コメント準備OKフラグをONにする
     * @param chats
     */
    public void setChats(Collection<MessageChat> chats) {
        mIsMessageOk = true;
        resetChats(chats);
    }
    /**
     * MessageChatを使って待ち行列を初期化する<br>
     * コメント準備OKフラグは変化しない
     * @param chats
     */
    public void resetChats(Collection<MessageChat> chats) {
        if (mChatsWait == null) {
            if (chats == null) {
                mChatsWait = new LinkedList<MessageChat>();
            } else {
                mChatsWait = new LinkedList<MessageChat>(chats);
            }
        } else {
            mChatsWait.clear();
            if (chats != null) {
                mChatsWait.addAll(chats);
            }
        }
        if (mChatsRunningNaka == null) {
            mChatsRunningNaka = new LinkedList<MessageChat>();
        } else {
            mChatsRunningNaka.clear();
        }
        if (mChatsRunningShita == null) {
            mChatsRunningShita = new LinkedList<MessageChat>();
        } else {
            mChatsRunningShita.clear();
        }
        if (mChatsRunningUe == null) {
            mChatsRunningUe = new LinkedList<MessageChat>();
        } else {
            mChatsRunningUe.clear();
        }
    }

    /**
     * コメント準備OKフラグをOFFにする
     */
    public void clear() {
        mIsMessageOk = false;
    }

    /**
     * @return コメント準備OKフラグ
     */
    public boolean isMessageOk() {
        return mIsMessageOk;
    }

    public List<MessageChat> getChatsWait() {
        return mChatsWait;
    }
    public List<MessageChat> getChatsRunningNaka() {
        return mChatsRunningNaka;
    }
    public List<MessageChat> getChatsRunningShita() {
        return mChatsRunningShita;
    }
    public List<MessageChat> getChatsRunningUe() {
        return mChatsRunningUe;
    }
}