package jp.sourceforge.nicoro;

import android.app.Instrumentation;
import android.content.res.Resources;
import android.support.v4.app.FragmentManager;
import android.test.ActivityInstrumentationTestCase2;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;
import junit.framework.AssertionFailedError;

public class PlayerInfoDialogFragmentTests extends ActivityInstrumentationTestCase2<AutoTestActivity> {
    private Instrumentation mInstr;
    private AutoTestActivity mActivity;
    private Resources mRes;

    @SuppressWarnings("deprecation")
    public PlayerInfoDialogFragmentTests() {
        super("jp.sourceforge.nicoro", AutoTestActivity.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        mInstr = getInstrumentation();

        mActivity = getActivity();
        mRes = mActivity.getResources();
        try {
            runTestOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mActivity.setContentView(new FrameLayout(mActivity));
                }
            });
        } catch (Throwable t) {
            AssertionFailedError e = new AssertionFailedError();
            e.initCause(t);
            throw e;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        mInstr = null;
        mActivity = null;
        mRes = null;

        super.tearDown();
    }

    public void testVideoDialog() throws Throwable {
        final PlayerInfoDialogFragment fragment =
            PlayerInfoDialogFragment.createInstanceForVideoDialog();
        runTestOnUiThread(new Runnable() {
            @Override
            public void run() {
                setTestDataForVideo(fragment);

                FragmentManager fm = mActivity.getSupportFragmentManager();
                fragment.show(fm, "dialog");
            }
        });
        mInstr.waitForIdleSync();

        assertCloseButtonForDialog(fragment);
        assertTestDataForVideo(fragment);
    }

    public void testVideoLayout() throws Throwable {
        final PlayerInfoDialogFragment fragment =
            PlayerInfoDialogFragment.createInstanceForVideoLayout();
        runTestOnUiThread(new Runnable() {
            @Override
            public void run() {
                setTestDataForVideo(fragment);

                FragmentManager fm = mActivity.getSupportFragmentManager();
                fm.beginTransaction().add(android.R.id.content, fragment).commit();
            }
        });
        mInstr.waitForIdleSync();

        assertCloseButtonForLayout(fragment);
        assertTestDataForVideo(fragment);
    }

    public void testLiveDialog() throws Throwable {
        final PlayerInfoDialogFragment fragment =
            PlayerInfoDialogFragment.createInstanceForLiveDialog();
        runTestOnUiThread(new Runnable() {
            @Override
            public void run() {
                setTestDataForLive(fragment);

                FragmentManager fm = mActivity.getSupportFragmentManager();
                fragment.show(fm, "dialog");
            }
        });
        mInstr.waitForIdleSync();

        assertCloseButtonForDialog(fragment);
        assertTestDataForLive(fragment);
    }

    public void testLiveLayout() throws Throwable {
        final PlayerInfoDialogFragment fragment =
            PlayerInfoDialogFragment.createInstanceForLiveLayout();
        runTestOnUiThread(new Runnable() {
            @Override
            public void run() {
                setTestDataForLive(fragment);

                FragmentManager fm = mActivity.getSupportFragmentManager();
                fm.beginTransaction().add(android.R.id.content, fragment).commit();
            }
        });
        mInstr.waitForIdleSync();

        assertCloseButtonForLayout(fragment);
        assertTestDataForLive(fragment);
    }

    private void setTestDataForVideo(PlayerInfoDialogFragment fragment) {
        fragment.setTitle("タイトル");
        fragment.setDescription("動画の説明");
        fragment.setFirstRetrieve("2007年08月31日投稿");
        fragment.setPlayData("MP4 640×480");
        ArrayList<String> tagList = new ArrayList<String>(2);
        tagList.add("タグ1");
        tagList.add("タグ2");
        fragment.setTagList(tagList);
        fragment.setCountPlay(3);
        fragment.setCountComment(4);
        fragment.setCountMylist(5);
        // TODO Thumbnailは今のところネットワーク接続必須なのでテスト省略
    }

    private void assertTestDataForVideo(PlayerInfoDialogFragment fragment) {
        View root = fragment.getView();

        VariableLabelView title = ViewUtil.findViewById(root, R.id.title);
        assertEquals("タイトル", title.getText());
        TextView description = ViewUtil.findViewById(root, R.id.description);
        assertEquals("動画の説明", description.getText().toString());
        VariableLabelView firstRetrieve = ViewUtil.findViewById(root, R.id.first_retrieve);
        assertEquals("2007年08月31日投稿", firstRetrieve.getText());
        VariableLabelView playData = ViewUtil.findViewById(root, R.id.play_data);
        assertEquals("MP4 640×480", playData.getText());
        TextView tagList = ViewUtil.findViewById(root, R.id.tag_list);
        String tagListString = tagList.getText().toString();
        assertTrue(tagListString.indexOf("タグ1") >= 0);
        assertTrue(tagListString.indexOf("タグ2") >= 0);
        VariableLabelView countPlay = ViewUtil.findViewById(root, R.id.count_play);
        assertEquals(mRes.getString(R.string.info_count_play) + "3",
                countPlay.getText());
        VariableLabelView countComment = ViewUtil.findViewById(root, R.id.count_comment);
        assertEquals(mRes.getString(R.string.info_count_comment) + "4",
                countComment.getText());
        VariableLabelView countMylist = ViewUtil.findViewById(root, R.id.count_mylist);
        assertEquals(mRes.getString(R.string.info_count_mylist) + "5",
                countMylist.getText());
    }

    private void setTestDataForLive(PlayerInfoDialogFragment fragment) {
        fragment.setTitle("生放送タイトル");
        fragment.setDescription("生放送の説明");
        fragment.setPlayData("FLV 640×480");
        fragment.setCountPlay(3);
        fragment.setCountComment(4);
        fragment.setSheet("座席");
    }

    private void assertTestDataForLive(PlayerInfoDialogFragment fragment) {
        View root = fragment.getView();

        VariableLabelView title = ViewUtil.findViewById(root, R.id.title);
        assertEquals("生放送タイトル", title.getText());
        TextView description = ViewUtil.findViewById(root, R.id.description);
        assertEquals("生放送の説明", description.getText().toString());
        VariableLabelView playData = ViewUtil.findViewById(root, R.id.play_data);
        assertEquals("FLV 640×480", playData.getText());
        VariableLabelView countPlay = ViewUtil.findViewById(root, R.id.count_play);
        assertEquals(mRes.getString(R.string.info_live_count_watch) + "3",
                countPlay.getText());
        VariableLabelView countComment = ViewUtil.findViewById(root, R.id.count_comment);
        assertEquals(mRes.getString(R.string.info_live_count_comment) + "4",
                countComment.getText());
        VariableLabelView sheet = ViewUtil.findViewById(root, R.id.count_mylist);
        assertEquals("座席", sheet.getText());
    }

    private void assertCloseButtonForDialog(PlayerInfoDialogFragment fragment) {
        View root = fragment.getView();
        View close = ViewUtil.findViewById(root, android.R.id.closeButton);
        assertNotNull(close);
        assertEquals(View.VISIBLE, close.getVisibility());
    }

    private void assertCloseButtonForLayout(PlayerInfoDialogFragment fragment) {
        View root = fragment.getView();
        View close = ViewUtil.findViewById(root, android.R.id.closeButton);
        assertNull(close);
    }
}
