package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;
import jp.sourceforge.nicoro.FailAnalyzeSwfException;

public class SoundStreamHead {
	public static final int SOUNDRATE_5_5 = 0;
	public static final int SOUNDRATE_11 = 1;
	public static final int SOUNDRATE_22 = 2;
	public static final int SOUNDRATE_44 = 3;
	
	public static final int SOUNDTYPE_MONO = 0;
	public static final int SOUNDTYPE_STEREO = 1;
	
	public static final int SOUNDCOMPRESSION_ADPCM = 1;
	public static final int SOUNDCOMPRESSION_MP3 = 2;
	
	public byte playbackSoundRate;		// UB[2]
	public byte playbackSoundSize;		// UB{1]
	public byte playbackSoundType;		// UB[1]
	public byte streamSoundCompression;	// UB[4]
	public byte streamSoundRate;		// UB[2]
	public byte streamSoundSize;		// UB[1]
	public byte streamSoundType;		// UB[1]
	public int streamSoundSampleCount;	// UI16
	public short latencySeek;		// SI16
	
    public int readSoundStreamHead(byte[] bufferArray, int offset) {
    	SoundStreamHead soundStreamHead = this;
    	
		soundStreamHead.playbackSoundRate =
			(byte) ((bufferArray[offset + 0] >> 2) & 0x03);
		soundStreamHead.playbackSoundSize =
			(byte) ((bufferArray[offset + 0] >> 1) & 0x01);
		soundStreamHead.playbackSoundType =
			(byte) (bufferArray[offset + 0] & 0x01);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf()
					.append("PlaybackSoundRate=").append(soundStreamHead.playbackSoundRate)
					.append(" PlaybackSoundSize=").append(soundStreamHead.playbackSoundSize)
					.append(" PlaybackSoundType=").append(soundStreamHead.playbackSoundType).toString());
		}
		
		soundStreamHead.streamSoundCompression =
			(byte) ((bufferArray[offset + 1] >> 4) & 0x0f);
		soundStreamHead.streamSoundRate =
			(byte) ((bufferArray[offset + 1] >> 2) & 0x03);
		soundStreamHead.streamSoundSize =
			(byte) ((bufferArray[offset + 1] >> 1) & 0x01);
		soundStreamHead.streamSoundType =
			(byte) (bufferArray[offset + 1] & 0x01);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf()
					.append("StreamSoundCompression=").append(soundStreamHead.streamSoundCompression)
					.append(" StreamSoundRate=").append(soundStreamHead.streamSoundRate)
					.append(" StreamSoundSize=").append(soundStreamHead.streamSoundSize)
					.append(" StreamSoundType=").append(soundStreamHead.streamSoundType).toString());
		}
		
		soundStreamHead.streamSoundSampleCount =
			(bufferArray[offset + 2] & 0xff) | ((bufferArray[offset + 3] & 0xff) << 8);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("StreamSoundSampleCount=")
					.append(soundStreamHead.streamSoundSampleCount).toString());
		}
		
		if (soundStreamHead.streamSoundCompression == SoundStreamHead.SOUNDCOMPRESSION_MP3) {
    		soundStreamHead.latencySeek =
    			(short) ((bufferArray[offset + 4] & 0xff) | ((bufferArray[offset + 5] & 0xff) << 8));
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("LatencySeek=")
    					.append(soundStreamHead.latencySeek).toString());
    		}
		}
		
//		// test
//		try {
//			mTestOutMP3 = new FileOutputStream("/sdcard/NicoRo/test.mp3");
//		} catch (FileNotFoundException e) {
//			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
//		}
    	
    	return offset + 6;
    }
    
    public StreamSoundDataBase createStreamSoundData() throws FailAnalyzeSwfException {
    	if (streamSoundCompression == SoundStreamHead.SOUNDCOMPRESSION_ADPCM) {
    		return new ADPCMSOUNDDATA();
    	} else if (streamSoundCompression == SoundStreamHead.SOUNDCOMPRESSION_MP3) {
    		return new MP3STREAMSOUNDDATA();
    	} else {
    		throw new FailAnalyzeSwfException("not supported StreamSoundCompression=" + streamSoundCompression);
    	}
    }
}
