package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;

public class NicoScriptDefault extends NicoScript {
    protected static final String COMMAND = "デフォルト";

    public NicoScriptDefault(MessageChatFork chat) {
        super(chat);
    }
    
    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.clearCommandDefault(this);
    }
    @Override
    public void onDraw(MessageChatController controller) {
        controller.setCommandDefault(this);
    }
    
    public int getColor() {
        return mChat.getColor();
    }
    
    public int getFontSize() {
        return mChat.getFontSize();
    }
    
    public int getPos() {
        return mChat.getPos();
    }
}
